/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.aggregates;

import com.palantir.logsafe.Arg;
import latitude.api.aggregates.ImmutableLatitudeAggregate;
import latitude.api.column.ColumnInfo;
import latitude.api.column.basic.BasicColumnInfoUtils;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableLatitudeAggregate.class)
@JsonSerialize(as=ImmutableLatitudeAggregate.class)
@Value.Immutable
public abstract class LatitudeAggregate {
    @JsonIgnore
    @Value.Derived
    public ColumnInfo column() {
        if (this.type() == AggregateType.COUNT) {
            return BasicColumnInfoUtils.ALL;
        }
        return this.serializedColumn();
    }

    @Nullable
    @JsonProperty(value="column")
    @Value.Parameter
    protected abstract ColumnInfo serializedColumn();

    @Value.Parameter
    public abstract AggregateType type();

    @Value.Parameter
    public abstract String alias();

    @Value.Check
    protected void validate() {
        ContourExceptions.client400CheckNotNullWithSafeMessage(this.column(), "Column cannot be null unless aggregateType is COUNT.", new Arg[0]);
    }

    public static LatitudeAggregate of(ColumnInfo valueColumn, AggregateType aggregateType, String alias) {
        return ImmutableLatitudeAggregate.of(valueColumn, aggregateType, alias);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableLatitudeAggregate.Builder {
    }

    public static enum AggregateType {
        SUM,
        MIN,
        MAX,
        COUNT,
        APPROXIMATE_COUNT_DISTINCT,
        COUNT_DISTINCT,
        STDEV,
        MEAN,
        MEDIAN,
        VARIANCE,
        NO_OP,
        NULL_COUNT,
        PERCENT_NULL;


        public boolean isNoArgument() {
            return this == COUNT;
        }
    }
}

