/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column;

import java.util.Set;
import latitude.api.jackson.ContourJacksonExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.collect.Sets;

public enum ColumnAttribute {
    SUMMARY("summary"),
    LATITUDE("latitude"),
    LONGITUDE("longitude"),
    GEOHASH("geohash"),
    RADIUS("radius"),
    SUMMABLE("summable"),
    COMPARABLE("comparable"),
    LOW_CARDINALITY("low-cardinality"),
    DATE("date"),
    TIME("time"),
    URL("url"),
    SELECTABLE("selectable"),
    NUMERIC("numeric"),
    HIDDEN("hidden"),
    STATSABLE("statsable"),
    IPADDRESS("ipaddress"),
    ID("ID"),
    GEOMETRY("geometry"),
    ALL_UPPERCASE("all-upper-case"),
    ALL_LOWERCASE("all-lower-case"),
    BOOLEAN("boolean"),
    PROMINENT("prominent");

    private final String name;

    private ColumnAttribute(String name) {
        this.name = name;
    }

    public static Set<ColumnAttribute> getBooleanAttributes() {
        return Sets.newHashSet(LOW_CARDINALITY, BOOLEAN);
    }

    public static Set<ColumnAttribute> getStringAttributes() {
        return Sets.newHashSet(COMPARABLE);
    }

    public static Set<ColumnAttribute> getNumberAttributes() {
        return Sets.newHashSet(STATSABLE, SUMMABLE, COMPARABLE, NUMERIC);
    }

    public static Set<ColumnAttribute> getLocalDateAttributes() {
        return ImmutableSet.of(DATE, TIME, COMPARABLE);
    }

    public static Set<ColumnAttribute> getDateTimeAttributes() {
        return ImmutableSet.of(TIME, COMPARABLE);
    }

    @JsonValue
    public final String getJsonValue() {
        return this.name;
    }

    @JsonCreator
    public static ColumnAttribute fromJsonValue(String jsonValue) {
        for (ColumnAttribute columnAttribute : ColumnAttribute.values()) {
            if (!columnAttribute.name.equals(jsonValue)) continue;
            return columnAttribute;
        }
        throw ContourJacksonExceptions.readJsonValueFailed(jsonValue);
    }
}

