/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.aliased;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.aliased.AliasedColumn;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class AliasedColumnV1
implements AliasedColumn {
    private final String identifier;
    private final ColumnInfo column;

    @JsonCreator
    public AliasedColumnV1(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="column") ColumnInfo column) {
        this.identifier = identifier;
        this.column = column;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.column.getDescription();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.column.getAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.getColumn().getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return this.getColumn().getJoinMetadataList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.column);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AliasedColumn other = (AliasedColumn)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier()) && Objects.equals(this.getColumn(), other.getColumn());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("identifier", this.identifier).add("column", this.column).toString();
    }
}

