/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.basic;

import com.palantir.logsafe.Unsafe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfoVisitor;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.basic.BasicColumnInfoV2;
import latitude.api.column.basic.determinism.ColumnDeterminismMetadata;
import latitude.api.column.basic.determinism.DeterministicColumnMetadata;
import latitude.api.column.basic.type.ContourFieldType;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;

public interface BasicColumnInfo
extends IdentifiableColumn {
    public static final ColumnDeterminismMetadata DEFAULT_DETERMINISM = DeterministicColumnMetadata.builder().build();

    @Override
    @Unsafe
    public String getName();

    @Override
    @Unsafe
    public String getIdentifier();

    public NavigableSet<ColumnAttribute> getAttributes();

    public String getIcon();

    public Optional<ContourFieldType> getFieldType();

    public Optional<ColumnDeterminismMetadata> getDeterminismMetadata();

    @JsonIgnore
    default public ColumnDeterminismMetadata getDeterminismMetadataOrDefault() {
        return this.getDeterminismMetadata().orElse(DEFAULT_DETERMINISM);
    }

    @Override
    default public <T, V extends ColumnInfoVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static class BasicColumnInfoBuilder {
        private String name;
        private String identifier;
        private String description;
        private String icon;
        private Set<ColumnAttribute> attributes = new HashSet<ColumnAttribute>();
        private List<Typeclass> typeclasses = new ArrayList<Typeclass>();
        private List<JoinMetadata> joinMetadataList = new ArrayList<JoinMetadata>();
        private String group;
        private List<String> sourceTables = new ArrayList<String>();
        private Optional<ContourFieldType> fieldType = Optional.empty();
        private Optional<ColumnDeterminismMetadata> determinismMetadata = Optional.empty();

        public static BasicColumnInfoBuilder create() {
            return new BasicColumnInfoBuilder();
        }

        public static BasicColumnInfoBuilder create(String nameAndIdentifier) {
            return new BasicColumnInfoBuilder().name(nameAndIdentifier).identifier(nameAndIdentifier);
        }

        public static BasicColumnInfoBuilder from(BasicColumnInfo original) {
            return new BasicColumnInfoBuilder().name(original.getName()).identifier(original.getIdentifier()).description(original.getDescription()).icon(original.getIcon()).attributes(original.getAttributes()).typeclasses(original.getTypeclasses()).joinMetadataList(original.getJoinMetadataList()).group(original.getGroup()).sourceTables(original.getSourceTables()).fieldType(original.getFieldType()).determinismMetadata(original.getDeterminismMetadata());
        }

        public BasicColumnInfoBuilder name(String name2) {
            this.name = name2;
            return this;
        }

        public BasicColumnInfoBuilder identifier(String id) {
            this.identifier = id;
            return this;
        }

        public BasicColumnInfoBuilder description(String desc) {
            this.description = desc;
            return this;
        }

        public BasicColumnInfoBuilder icon(String icn) {
            this.icon = icn;
            return this;
        }

        public BasicColumnInfoBuilder attributes(Set<ColumnAttribute> attrs) {
            if (attrs != null) {
                this.attributes.addAll(attrs);
            }
            return this;
        }

        public BasicColumnInfoBuilder attribute(ColumnAttribute attribute) {
            if (attribute != null) {
                this.attributes.add(attribute);
            }
            return this;
        }

        public BasicColumnInfoBuilder typeclasses(List<Typeclass> typecls) {
            if (typecls != null) {
                this.typeclasses.addAll(typecls);
            }
            return this;
        }

        public BasicColumnInfoBuilder typeclass(Typeclass typeclass) {
            if (typeclass != null) {
                this.typeclasses.add(typeclass);
            }
            return this;
        }

        public BasicColumnInfoBuilder joinMetadataList(List<JoinMetadata> metadatas) {
            if (metadatas != null) {
                this.joinMetadataList.addAll(metadatas);
            }
            return this;
        }

        public BasicColumnInfoBuilder joinMetadata(JoinMetadata metadata) {
            if (metadata != null) {
                this.joinMetadataList.add(metadata);
            }
            return this;
        }

        public BasicColumnInfoBuilder group(String grp) {
            this.group = grp;
            return this;
        }

        public BasicColumnInfoBuilder sourceTables(List<String> src) {
            this.sourceTables.addAll(src);
            return this;
        }

        public BasicColumnInfoBuilder sourceTable(String sourceTable) {
            if (sourceTable != null) {
                this.sourceTables.add(sourceTable);
            }
            return this;
        }

        public BasicColumnInfoBuilder fieldType(ContourFieldType type) {
            this.fieldType = Optional.of(type);
            return this;
        }

        public BasicColumnInfoBuilder fieldType(Optional<ContourFieldType> type) {
            this.fieldType = type;
            return this;
        }

        public BasicColumnInfoBuilder determinismMetadata(ColumnDeterminismMetadata metadata) {
            this.determinismMetadata = Optional.of(metadata);
            return this;
        }

        public BasicColumnInfoBuilder determinismMetadata(Optional<ColumnDeterminismMetadata> metadata) {
            this.determinismMetadata = metadata;
            return this;
        }

        public BasicColumnInfoV2 build() {
            return new BasicColumnInfoV2(this.name, this.identifier, Optional.ofNullable(this.description), this.icon, this.attributes, this.typeclasses, Optional.of(this.joinMetadataList), Optional.of(this.sourceTables), Optional.ofNullable(this.group), this.fieldType, this.determinismMetadata);
        }
    }
}

