/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.basic;

import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.basic.BasicColumnInfo;
import latitude.api.column.basic.BasicColumnInfoV2;
import latitude.api.column.basic.determinism.ColumnDeterminismMetadata;
import latitude.api.column.basic.type.ContourFieldType;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.versioned.VersionUpdatingConverter;
import latitude.api.versioned.Versioned;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.collect.ImmutableSortedSet;

@Deprecated
@JsonDeserialize(converter=BasicColumnUpdater.class)
public final class BasicColumnInfoV1
implements Versioned<BasicColumnInfoV2>,
BasicColumnInfo {
    private final String name;
    private final String identifier;
    private final String icon;
    private final Set<ColumnAttribute> attributes;
    private final List<String> typeclasses;
    private final List<String> sourceTables;
    private final String group;
    private final Optional<ContourFieldType> fieldType;
    private final Optional<ColumnDeterminismMetadata> determinismMetadata;

    public BasicColumnInfoV1(@JsonProperty(value="name") String name, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="icon") String icon, @JsonProperty(value="attributes") Set<ColumnAttribute> attributes, @JsonProperty(value="typeclasses") List<String> typeclasses, @JsonProperty(value="sourceTables") Optional<List<String>> sourceTables, @JsonProperty(value="group") Optional<String> group, @JsonProperty(value="fieldType") Optional<ContourFieldType> fieldType, @JsonProperty(value="determinismMetadata") Optional<ColumnDeterminismMetadata> determinismMetadata) {
        this.name = name;
        this.identifier = identifier;
        this.icon = icon;
        this.attributes = attributes != null ? attributes : ImmutableSet.of();
        this.typeclasses = typeclasses;
        this.sourceTables = sourceTables.orElseGet(ImmutableList::of);
        this.group = group.orElse(null);
        this.fieldType = fieldType;
        this.determinismMetadata = determinismMetadata;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("column", this.identifier).add("icon", this.icon).add("attributes", this.attributes).add("typeclasses", this.typeclasses).add("sourceTables", this.sourceTables).add("group", this.group).add("fieldType", this.fieldType).add("determinismMetadata", this.determinismMetadata).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<ContourFieldType> getFieldType() {
        return this.fieldType;
    }

    @Override
    public Optional<ColumnDeterminismMetadata> getDeterminismMetadata() {
        return this.determinismMetadata;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public NavigableSet<ColumnAttribute> getAttributes() {
        return ImmutableSortedSet.copyOf(this.attributes);
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return Typeclass.legacyFallback(this.typeclasses);
    }

    @JsonProperty(value="typeclasses")
    public List<String> getLegacyTypeclasses() {
        return this.typeclasses;
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getSourceTables() {
        return this.sourceTables;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.icon, this.name, this.typeclasses, this.attributes, this.sourceTables, this.group, this.fieldType, this.determinismMetadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicColumnInfo other = (BasicColumnInfo)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getIdentifier(), other.getIdentifier()) && Objects.equals(this.getIcon(), other.getIcon()) && Objects.equals(this.getGroup(), other.getGroup()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getTypeclasses(), other.getTypeclasses()) && Objects.equals(this.getSourceTables(), other.getSourceTables()) && Objects.equals(this.getFieldType(), other.getFieldType()) && Objects.equals(this.getDeterminismMetadata(), other.getDeterminismMetadata());
    }

    @Override
    public BasicColumnInfoV2 asLatestVersion() {
        return BasicColumnInfo.BasicColumnInfoBuilder.create().name(this.getName()).identifier(this.getIdentifier()).icon(this.getIcon()).attributes(this.getAttributes()).typeclasses(this.getTypeclasses()).sourceTables(this.getSourceTables()).group(this.getGroup()).fieldType(this.getFieldType()).determinismMetadata(this.getDeterminismMetadata()).build();
    }

    static class BasicColumnUpdater
    extends VersionUpdatingConverter<BasicColumnInfoV1, BasicColumnInfoV2> {
        BasicColumnUpdater() {
        }
    }
}

