/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.basic;

import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.basic.BasicColumnInfo;
import latitude.api.column.basic.determinism.ColumnDeterminismMetadata;
import latitude.api.column.basic.type.ContourFieldType;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.collect.ImmutableSortedSet;
import shadow.palantir.driver.javax.annotation.Nullable;

public class BasicColumnInfoV2
implements BasicColumnInfo {
    private final String name;
    private final String identifier;
    private final String description;
    private final String icon;
    private final Set<ColumnAttribute> attributes;
    private final List<Typeclass> typeclasses;
    private final List<JoinMetadata> joinMetadataList;
    private final List<String> sourceTables;
    private final String group;
    private final Optional<ContourFieldType> fieldType;
    private final Optional<ColumnDeterminismMetadata> determinismMetadata;

    protected BasicColumnInfoV2(@JsonProperty(value="name") String name, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="description") Optional<String> description, @JsonProperty(value="icon") String icon, @JsonProperty(value="attributes") Set<ColumnAttribute> attributes, @JsonProperty(value="typeclasses") List<Typeclass> typeclasses, @JsonProperty(value="joinMetadataList") Optional<List<JoinMetadata>> joinMetadataList, @JsonProperty(value="sourceTables") Optional<List<String>> sourceTables, @JsonProperty(value="group") Optional<String> group, @JsonProperty(value="fieldType") Optional<ContourFieldType> fieldType, @JsonProperty(value="determinismMetadata") Optional<ColumnDeterminismMetadata> columnDeterminismMetadata) {
        this.name = name;
        this.identifier = identifier;
        this.description = description.orElse(null);
        this.icon = icon;
        this.attributes = attributes != null ? attributes : ImmutableSet.of();
        this.typeclasses = typeclasses != null ? typeclasses : ImmutableList.of();
        this.joinMetadataList = joinMetadataList.orElseGet(ImmutableList::of);
        this.sourceTables = sourceTables.orElseGet(ImmutableList::of);
        this.fieldType = fieldType;
        this.group = group.orElse(null);
        this.determinismMetadata = columnDeterminismMetadata;
    }

    @Override
    @Nullable
    public final List<Typeclass> getTypeclasses() {
        return this.typeclasses;
    }

    @Override
    public List<JoinMetadata> getJoinMetadataList() {
        return this.joinMetadataList;
    }

    @Override
    @Nullable
    public final List<String> getSourceTables() {
        return this.sourceTables;
    }

    @Override
    @Nullable
    public final String getGroup() {
        return this.group;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final String getIcon() {
        return this.icon;
    }

    @Override
    public final NavigableSet<ColumnAttribute> getAttributes() {
        return ImmutableSortedSet.copyOf(this.attributes);
    }

    @Override
    public Optional<ContourFieldType> getFieldType() {
        return this.fieldType;
    }

    @Override
    public Optional<ColumnDeterminismMetadata> getDeterminismMetadata() {
        return this.determinismMetadata;
    }

    public static BasicColumnInfoV2 named(String name) {
        return BasicColumnInfo.BasicColumnInfoBuilder.create(name).build();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicColumnInfoV2 that = (BasicColumnInfoV2)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.description, that.description) && Objects.equals(this.icon, that.icon) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.typeclasses, that.typeclasses) && Objects.equals(this.joinMetadataList, that.joinMetadataList) && Objects.equals(this.sourceTables, that.sourceTables) && Objects.equals(this.group, that.group) && Objects.equals(this.fieldType, that.fieldType) && Objects.equals(this.determinismMetadata, that.determinismMetadata);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.identifier, this.description, this.icon, this.attributes, this.typeclasses, this.joinMetadataList, this.sourceTables, this.group, this.fieldType, this.determinismMetadata);
    }

    public String toString() {
        return "BasicColumnInfoV2{name='" + this.name + "', identifier='" + this.identifier + "', description='" + this.description + "', icon='" + this.icon + "', attributes=" + this.attributes + ", typeclasses=" + this.typeclasses + ", joinMetadataList=" + this.joinMetadataList + ", sourceTables=" + this.sourceTables + ", group='" + this.group + ", fieldType='" + this.fieldType + ", determinismMetadata='" + this.determinismMetadata + "'}";
    }
}

