/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.basic.type;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import latitude.api.column.basic.type.ContourFieldType;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public abstract class ContourFieldTypeTuple {
    public static final ContourFieldType BYTE = ContourFieldType.builder().foundryFieldType(FoundryFieldType.BYTE).build();
    public static final ContourFieldType INTEGER = ContourFieldType.builder().foundryFieldType(FoundryFieldType.INTEGER).build();
    public static final ContourFieldType SHORT = ContourFieldType.builder().foundryFieldType(FoundryFieldType.SHORT).build();
    public static final ContourFieldType LONG = ContourFieldType.builder().foundryFieldType(FoundryFieldType.LONG).build();
    public static final ContourFieldType FLOAT = ContourFieldType.builder().foundryFieldType(FoundryFieldType.FLOAT).build();
    public static final ContourFieldType DOUBLE = ContourFieldType.builder().foundryFieldType(FoundryFieldType.DOUBLE).build();
    public static final ContourFieldType DECIMAL = ContourFieldType.builder().foundryFieldType(FoundryFieldType.DECIMAL).build();
    public static final ContourFieldType BOOLEAN = ContourFieldType.builder().foundryFieldType(FoundryFieldType.BOOLEAN).build();
    public static final ContourFieldType DATE = ContourFieldType.builder().foundryFieldType(FoundryFieldType.DATE).build();
    public static final ContourFieldType TIMESTAMP = ContourFieldType.builder().foundryFieldType(FoundryFieldType.TIMESTAMP).build();
    public static final ContourFieldType STRING = ContourFieldType.builder().foundryFieldType(FoundryFieldType.STRING).build();
    public static final ContourFieldType BINARY = ContourFieldType.builder().foundryFieldType(FoundryFieldType.BINARY).build();

    public abstract FoundryFieldType foundryFieldType();

    public abstract Optional<ContourFieldType> arrayInnerType();

    public abstract Optional<ContourFieldType> mapKeyType();

    public abstract Optional<ContourFieldType> mapValueType();

    public abstract Optional<List<ContourFieldType>> structSubTypes();

    public static ContourFieldType from(FoundryFieldSchema foundryFieldSchema) {
        return ContourFieldType.builder().foundryFieldType(foundryFieldSchema.getType()).arrayInnerType(ContourFieldTypeTuple.maybeGetContourFieldType(foundryFieldSchema.getArraySubtype())).mapKeyType(ContourFieldTypeTuple.maybeGetContourFieldType(foundryFieldSchema.getMapKeyType())).mapValueType(ContourFieldTypeTuple.maybeGetContourFieldType(foundryFieldSchema.getMapValueType())).structSubTypes(ContourFieldTypeTuple.maybeGetContourFieldTypes(foundryFieldSchema.getSubSchemas())).build();
    }

    public static Optional<ContourFieldType> extractFrom(Object objectValue) {
        if (objectValue instanceof String) {
            return Optional.of(ContourFieldType.STRING);
        }
        if (objectValue instanceof Integer) {
            return Optional.of(ContourFieldType.INTEGER);
        }
        if (objectValue instanceof Short) {
            return Optional.of(ContourFieldType.SHORT);
        }
        if (objectValue instanceof Long) {
            return Optional.of(ContourFieldType.LONG);
        }
        if (objectValue instanceof Float) {
            return Optional.of(ContourFieldType.FLOAT);
        }
        if (objectValue instanceof Double) {
            return Optional.of(ContourFieldType.DOUBLE);
        }
        if (objectValue instanceof BigDecimal) {
            return Optional.of(ContourFieldType.DECIMAL);
        }
        if (objectValue instanceof Boolean) {
            return Optional.of(ContourFieldType.BOOLEAN);
        }
        if (objectValue instanceof Timestamp) {
            return Optional.of(ContourFieldType.TIMESTAMP);
        }
        if (objectValue instanceof Date) {
            return Optional.of(ContourFieldType.DATE);
        }
        if (objectValue instanceof Byte) {
            return Optional.of(ContourFieldType.BYTE);
        }
        return Optional.empty();
    }

    private static Optional<ContourFieldType> maybeGetContourFieldType(Optional<FoundryFieldSchema> maybeSchema) {
        if (!maybeSchema.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(ContourFieldTypeTuple.from(maybeSchema.get()));
    }

    private static Optional<List<ContourFieldType>> maybeGetContourFieldTypes(Optional<List<FoundryFieldSchema>> maybeSubSchema) {
        if (!maybeSubSchema.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(maybeSubSchema.get().stream().map(schema -> ContourFieldTypeTuple.maybeGetContourFieldType(Optional.of(schema))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }
}

