/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.binarynumeric;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.ColumnInfoVisitor;
import latitude.api.column.DerivedColumnInfo;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.BinaryExpression;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;

public interface BinaryNumericColumnInfo
extends DerivedColumnInfo {
    public Operation getOperation();

    public ColumnInfo getLeft();

    public ColumnInfo getRight();

    @Override
    @Unsafe
    public String getName();

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes();

    @Override
    default public <T, V extends ColumnInfoVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static enum Operation {
        SUM,
        DIFFERENCE,
        PRODUCT,
        MODULO,
        QUOTIENT;


        public String getName() {
            switch (this) {
                case SUM: {
                    return "plus";
                }
                case DIFFERENCE: {
                    return "minus";
                }
                case PRODUCT: {
                    return "times";
                }
                case MODULO: {
                    return "mod";
                }
                case QUOTIENT: {
                    return "divided_by";
                }
            }
            throw ContourExceptions.server500IllegalEnum(this);
        }

        public static Operation toBinaryNumericOperationOrThrow(BinaryExpression.BinaryOperation binaryOperation) {
            switch (binaryOperation) {
                case DIVIDE: {
                    return QUOTIENT;
                }
                case MULTIPLY: {
                    return PRODUCT;
                }
                case SUBTRACT: {
                    return DIFFERENCE;
                }
                case ADD: {
                    return SUM;
                }
                case MODULUS: {
                    return MODULO;
                }
                case CONCATENATE: 
                case IS: 
                case OR: 
                case AND: 
                case LIKE: 
                case EQUAL: 
                case RLIKE: 
                case IS_NOT: 
                case LESS_THAN: 
                case NOT_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    throw ContourExceptions.server500("Cannot convert the provided BinaryOperation to an BinaryNumericOperation as the BinaryOperation does not return a number.", SafeArg.of("binaryOperation", binaryOperation));
                }
            }
            throw ContourExceptions.server500IllegalEnum(binaryOperation);
        }
    }
}

