/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.binarynumeric;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.ColumnInfoContainer;
import latitude.api.column.binarynumeric.BinaryNumericColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.Sets;

public final class BinaryNumericColumnInfoV1
implements BinaryNumericColumnInfo {
    private final BinaryNumericColumnInfo.Operation operation;
    private final ColumnInfo left;
    private final ColumnInfo right;
    private final String name;

    public BinaryNumericColumnInfoV1(@JsonProperty(value="operation") BinaryNumericColumnInfo.Operation operation, @JsonProperty(value="left") ColumnInfo left, @JsonProperty(value="right") ColumnInfo right, @JsonProperty(value="method") Optional<ColumnInfoContainer.DerivedColumnMethod> _ignored, @JsonProperty(value="name") Optional<String> name) {
        this.operation = operation;
        this.left = left;
        this.right = right;
        this.name = name.orElse(null);
    }

    @Override
    public BinaryNumericColumnInfo.Operation getOperation() {
        return this.operation;
    }

    @Override
    public ColumnInfo getLeft() {
        return this.left;
    }

    @Override
    public ColumnInfo getRight() {
        return this.right;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        if (!Strings.isNullOrEmpty(this.name) || this.left == null || this.right == null || this.operation == null) {
            return this.name;
        }
        return this.left.getName() + "_" + this.operation.getName() + "_" + this.right.getName();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        if (this.left != null && this.right != null) {
            return Sets.intersection(this.left.getAttributes(), this.right.getAttributes());
        }
        if (this.left != null) {
            return this.left.getAttributes();
        }
        if (this.right != null) {
            return this.right.getAttributes();
        }
        return new HashSet<ColumnAttribute>();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.left.getSourceTables())).addAll(this.right.getSourceTables())).build();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return Objects.equals(this.left.getGroup(), this.right.getGroup()) ? this.left.getGroup() : null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.left, this.right, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryNumericColumnInfoV1 that = (BinaryNumericColumnInfoV1)obj;
        return Objects.equals((Object)this.operation, (Object)that.operation) && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("operation", (Object)this.operation).add("left", this.left).add("right", this.right).add("name", this.name).toString();
    }

    @Override
    public boolean isValid() {
        return this.getOperation() != null && this.getLeft() != null && this.getRight() != null;
    }
}

