/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.binarynumericconstant;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.binarynumeric.BinaryNumericColumnInfo;
import latitude.api.column.binarynumericconstant.BinaryNumericConstantColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.base.Strings;

public final class BinaryNumericConstantColumnInfoV1
implements BinaryNumericConstantColumnInfo {
    private final BinaryNumericColumnInfo.Operation operation;
    private final ColumnInfo left;
    private final Double right;
    private final String name;

    public BinaryNumericConstantColumnInfoV1(@JsonProperty(value="operation") BinaryNumericColumnInfo.Operation operation, @JsonProperty(value="left") ColumnInfo left, @JsonProperty(value="right") Double right, @JsonProperty(value="name") Optional<String> name) {
        this.operation = operation;
        this.left = left;
        this.right = right;
        this.name = name.orElse(null);
    }

    @Override
    public BinaryNumericColumnInfo.Operation getOperation() {
        return this.operation;
    }

    @Override
    public ColumnInfo getLeft() {
        return this.left;
    }

    @Override
    public Double getRight() {
        return this.right;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        if (!Strings.isNullOrEmpty(this.name) || this.left == null || this.operation == null || this.right == null) {
            return this.name;
        }
        return this.left.getName() + "_" + this.operation.getName() + "_" + this.right;
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.left.getAttributes();
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        return this.getOperation() != null && this.getLeft() != null && this.getRight() != null && !Double.isInfinite(this.getRight());
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.left.getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return this.left.getJoinMetadataList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.left.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.left.getGroup();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.left, this.right, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryNumericConstantColumnInfoV1 that = (BinaryNumericConstantColumnInfoV1)obj;
        return Objects.equals((Object)this.operation, (Object)that.operation) && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("operation", (Object)this.operation).add("left", this.left).add("right", this.right).add("name", this.name).toString();
    }
}

