/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.constant;

import com.palantir.logsafe.Arg;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.constant.ConstantColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.javax.annotation.Nullable;

public class ConstantColumnInfoV2
implements ConstantColumnInfo {
    private final Long longValue;
    private final Double doubleValue;
    private final String stringValue;
    private final List<Typeclass> typeclasses;

    @JsonCreator
    public ConstantColumnInfoV2(@JsonProperty(value="longValue") @Nullable Long longValue, @JsonProperty(value="doubleValue") @Nullable Double doubleValue, @JsonProperty(value="stringValue") @Nullable String stringValue, @JsonProperty(value="typeclasses") List<Typeclass> typeclasses) {
        this.longValue = longValue;
        this.doubleValue = doubleValue;
        this.stringValue = stringValue;
        this.typeclasses = typeclasses;
    }

    public ConstantColumnInfoV2(Long longValue) {
        this(longValue, null, null, ImmutableList.of());
    }

    public ConstantColumnInfoV2(Double doubleValue) {
        this(null, doubleValue, null, ImmutableList.of());
    }

    public ConstantColumnInfoV2(String stringValue) {
        this(null, null, stringValue, ImmutableList.of());
    }

    @Override
    public final Long getLongValue() {
        return this.longValue;
    }

    @Override
    public final Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public final String getStringValue() {
        return this.stringValue;
    }

    @Override
    @Nullable
    public final List<Typeclass> getTypeclasses() {
        return this.typeclasses;
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    @JsonIgnore
    public final List<String> getSourceTables() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    @JsonIgnore
    public final String getGroup() {
        return null;
    }

    @Override
    @JsonIgnore
    public final String getName() {
        return "Constant";
    }

    @Override
    @JsonIgnore
    public final String getDescription() {
        return null;
    }

    @Override
    public final Object retrieveValue() {
        if (this.longValue != null) {
            return this.longValue;
        }
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        throw ContourExceptions.server500("ConstantColumn must have a non-null value.", new Arg[0]);
    }

    @Override
    @JsonIgnore
    public final Set<ColumnAttribute> getAttributes() {
        if (this.longValue != null || this.doubleValue != null) {
            return ImmutableSet.of(ColumnAttribute.NUMERIC, ColumnAttribute.SUMMABLE);
        }
        return Collections.emptySet();
    }

    public final int hashCode() {
        return Objects.hash(this.longValue, this.doubleValue, this.stringValue, this.typeclasses);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantColumnInfoV2 other = (ConstantColumnInfoV2)obj;
        return Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getDoubleValue(), other.getDoubleValue()) && Objects.equals(this.getLongValue(), other.getLongValue()) && Objects.equals(this.getStringValue(), other.getStringValue()) && Objects.equals(this.getTypeclasses(), other.getTypeclasses());
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("longValue", this.longValue).add("doubleValue", this.doubleValue).add("stringValue", this.stringValue).add("typeclasses", this.typeclasses).toString();
    }
}

