/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.geohash;

import com.palantir.logsafe.Unsafe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.geohash.GeohashColumnInfo;
import latitude.api.column.geohash.ImmutableGeohashColumnInfoV1;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonSerialize(as=ImmutableGeohashColumnInfoV1.class)
@JsonDeserialize(as=ImmutableGeohashColumnInfoV1.class)
@Value.Immutable
public abstract class GeohashColumnInfoV1
implements GeohashColumnInfo {
    @Override
    @Value.Parameter
    public abstract ColumnInfo getLatitudeColumn();

    @Override
    @Value.Parameter
    public abstract ColumnInfo getLongitudeColumn();

    @Override
    @Value.Parameter
    public abstract int getPrecision();

    @Override
    @Value.Parameter
    public abstract String getIdentifier();

    @Override
    @JsonIgnore
    public final Set<ColumnAttribute> getAttributes() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(ColumnAttribute.getNumberAttributes())).add((Object)ColumnAttribute.GEOHASH)).build();
    }

    @Override
    @JsonIgnore
    public final List<Typeclass> getTypeclasses() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public final List<String> getSourceTables() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getLatitudeColumn().getSourceTables())).addAll(this.getLongitudeColumn().getSourceTables())).build();
    }

    @Override
    @JsonIgnore
    public final String getGroup() {
        return Objects.equals(this.getLatitudeColumn().getGroup(), this.getLongitudeColumn().getGroup()) ? this.getLatitudeColumn().getGroup() : null;
    }

    @Override
    @JsonIgnore
    public final String getName() {
        return "geohash_of_" + this.getLatitudeColumn().getName() + "_and_" + this.getLongitudeColumn().getName();
    }

    @Override
    @Unsafe
    @JsonIgnore
    public final String getDescription() {
        return "Geohash of " + this.getLatitudeColumn().getName() + " and " + this.getLongitudeColumn().getName();
    }

    @Override
    @JsonIgnore
    public final boolean isValid() {
        return this.getLatitudeColumn() != null && this.getLongitudeColumn() != null;
    }

    public static GeohashColumnInfoV1 of(ColumnInfo latitudeColumn, ColumnInfo longitudeColumn, int precision, String identifier) {
        return ImmutableGeohashColumnInfoV1.of(latitudeColumn, longitudeColumn, precision, identifier);
    }
}

