/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.geohash;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.column.ColumnInfo;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.geohash.GeohashColumnInfo;
import latitude.api.column.geohash.GeohashColumnInfoV1;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeohashColumnInfoV1", generator="Immutables")
@Immutable
public final class ImmutableGeohashColumnInfoV1
extends GeohashColumnInfoV1 {
    private final ColumnInfo latitudeColumn;
    private final ColumnInfo longitudeColumn;
    private final int precision;
    private final String identifier;

    private ImmutableGeohashColumnInfoV1(ColumnInfo latitudeColumn, ColumnInfo longitudeColumn, int precision, String identifier) {
        this.latitudeColumn = Objects.requireNonNull(latitudeColumn, "latitudeColumn");
        this.longitudeColumn = Objects.requireNonNull(longitudeColumn, "longitudeColumn");
        this.precision = precision;
        this.identifier = Objects.requireNonNull(identifier, "identifier");
    }

    private ImmutableGeohashColumnInfoV1(ImmutableGeohashColumnInfoV1 original, ColumnInfo latitudeColumn, ColumnInfo longitudeColumn, int precision, String identifier) {
        this.latitudeColumn = latitudeColumn;
        this.longitudeColumn = longitudeColumn;
        this.precision = precision;
        this.identifier = identifier;
    }

    @Override
    @JsonProperty(value="latitudeColumn")
    public ColumnInfo getLatitudeColumn() {
        return this.latitudeColumn;
    }

    @Override
    @JsonProperty(value="longitudeColumn")
    public ColumnInfo getLongitudeColumn() {
        return this.longitudeColumn;
    }

    @Override
    @JsonProperty(value="precision")
    public int getPrecision() {
        return this.precision;
    }

    @Override
    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    public final ImmutableGeohashColumnInfoV1 withLatitudeColumn(ColumnInfo value) {
        if (this.latitudeColumn == value) {
            return this;
        }
        ColumnInfo newValue = Objects.requireNonNull(value, "latitudeColumn");
        return new ImmutableGeohashColumnInfoV1(this, newValue, this.longitudeColumn, this.precision, this.identifier);
    }

    public final ImmutableGeohashColumnInfoV1 withLongitudeColumn(ColumnInfo value) {
        if (this.longitudeColumn == value) {
            return this;
        }
        ColumnInfo newValue = Objects.requireNonNull(value, "longitudeColumn");
        return new ImmutableGeohashColumnInfoV1(this, this.latitudeColumn, newValue, this.precision, this.identifier);
    }

    public final ImmutableGeohashColumnInfoV1 withPrecision(int value) {
        if (this.precision == value) {
            return this;
        }
        return new ImmutableGeohashColumnInfoV1(this, this.latitudeColumn, this.longitudeColumn, value, this.identifier);
    }

    public final ImmutableGeohashColumnInfoV1 withIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "identifier");
        if (this.identifier.equals(newValue)) {
            return this;
        }
        return new ImmutableGeohashColumnInfoV1(this, this.latitudeColumn, this.longitudeColumn, this.precision, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeohashColumnInfoV1 && this.equalTo(0, (ImmutableGeohashColumnInfoV1)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeohashColumnInfoV1 another) {
        return this.latitudeColumn.equals(another.latitudeColumn) && this.longitudeColumn.equals(another.longitudeColumn) && this.precision == another.precision && this.identifier.equals(another.identifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.latitudeColumn.hashCode();
        h += (h << 5) + this.longitudeColumn.hashCode();
        h += (h << 5) + this.precision;
        h += (h << 5) + this.identifier.hashCode();
        return h;
    }

    public String toString() {
        return "GeohashColumnInfoV1{latitudeColumn=" + this.latitudeColumn + ", longitudeColumn=" + this.longitudeColumn + ", precision=" + this.precision + ", identifier=" + this.identifier + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeohashColumnInfoV1 fromJson(Json json) {
        Builder builder = ImmutableGeohashColumnInfoV1.builder();
        if (json.latitudeColumn != null) {
            builder.latitudeColumn(json.latitudeColumn);
        }
        if (json.longitudeColumn != null) {
            builder.longitudeColumn(json.longitudeColumn);
        }
        if (json.precisionIsSet) {
            builder.precision(json.precision);
        }
        if (json.identifier != null) {
            builder.identifier(json.identifier);
        }
        return builder.build();
    }

    public static ImmutableGeohashColumnInfoV1 of(ColumnInfo latitudeColumn, ColumnInfo longitudeColumn, int precision, String identifier) {
        return new ImmutableGeohashColumnInfoV1(latitudeColumn, longitudeColumn, precision, identifier);
    }

    public static ImmutableGeohashColumnInfoV1 copyOf(GeohashColumnInfoV1 instance) {
        if (instance instanceof ImmutableGeohashColumnInfoV1) {
            return (ImmutableGeohashColumnInfoV1)instance;
        }
        return ImmutableGeohashColumnInfoV1.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeohashColumnInfoV1", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LATITUDE_COLUMN = 1L;
        private static final long INIT_BIT_LONGITUDE_COLUMN = 2L;
        private static final long INIT_BIT_PRECISION = 4L;
        private static final long INIT_BIT_IDENTIFIER = 8L;
        private long initBits = 15L;
        @Nullable
        private ColumnInfo latitudeColumn;
        @Nullable
        private ColumnInfo longitudeColumn;
        private int precision;
        @Nullable
        private String identifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeohashColumnInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IdentifiableColumn instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeohashColumnInfoV1 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IdentifiableColumn instance;
            long bits = 0L;
            if (object instanceof GeohashColumnInfo) {
                instance = (GeohashColumnInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.getIdentifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.latitudeColumn(instance.getLatitudeColumn());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.longitudeColumn(instance.getLongitudeColumn());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.precision(instance.getPrecision());
                    bits |= 2L;
                }
            }
            if (object instanceof IdentifiableColumn) {
                instance = (IdentifiableColumn)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.getIdentifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GeohashColumnInfoV1) {
                instance = (GeohashColumnInfoV1)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(((GeohashColumnInfoV1)instance).getIdentifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.latitudeColumn(((GeohashColumnInfoV1)instance).getLatitudeColumn());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.longitudeColumn(((GeohashColumnInfoV1)instance).getLongitudeColumn());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.precision(((GeohashColumnInfoV1)instance).getPrecision());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="latitudeColumn")
        @CanIgnoreReturnValue
        public final Builder latitudeColumn(ColumnInfo latitudeColumn) {
            this.latitudeColumn = Objects.requireNonNull(latitudeColumn, "latitudeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="longitudeColumn")
        @CanIgnoreReturnValue
        public final Builder longitudeColumn(ColumnInfo longitudeColumn) {
            this.longitudeColumn = Objects.requireNonNull(longitudeColumn, "longitudeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="precision")
        @CanIgnoreReturnValue
        public final Builder precision(int precision) {
            this.precision = precision;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="identifier")
        @CanIgnoreReturnValue
        public final Builder identifier(String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGeohashColumnInfoV1 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeohashColumnInfoV1(null, this.latitudeColumn, this.longitudeColumn, this.precision, this.identifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitudeColumn");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitudeColumn");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("precision");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("identifier");
            }
            return "Cannot build GeohashColumnInfoV1, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeohashColumnInfoV1", generator="Immutables")
    static final class Json
    extends GeohashColumnInfoV1 {
        @Nullable
        ColumnInfo latitudeColumn;
        @Nullable
        ColumnInfo longitudeColumn;
        int precision;
        boolean precisionIsSet;
        @Nullable
        String identifier;

        Json() {
        }

        @JsonProperty(value="latitudeColumn")
        public void setLatitudeColumn(ColumnInfo latitudeColumn) {
            this.latitudeColumn = latitudeColumn;
        }

        @JsonProperty(value="longitudeColumn")
        public void setLongitudeColumn(ColumnInfo longitudeColumn) {
            this.longitudeColumn = longitudeColumn;
        }

        @JsonProperty(value="precision")
        public void setPrecision(int precision) {
            this.precision = precision;
            this.precisionIsSet = true;
        }

        @JsonProperty(value="identifier")
        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public ColumnInfo getLatitudeColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnInfo getLongitudeColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPrecision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentifier() {
            throw new UnsupportedOperationException();
        }
    }
}

