/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.hashed;

import com.palantir.logsafe.Unsafe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.hashed.HashFunctionType;
import latitude.api.column.hashed.HashedColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HashedColumnInfoV1
implements HashedColumnInfo {
    private final IdentifiableColumn column;
    private final HashFunctionType hashFunctionType;

    public HashedColumnInfoV1(@JsonProperty(value="column") IdentifiableColumn column, @JsonProperty(value="hashFunctionType") HashFunctionType hashFunctionType) {
        this.column = column;
        this.hashFunctionType = hashFunctionType;
    }

    @Override
    @Nullable
    public final Set<ColumnAttribute> getAttributes() {
        return this.column.getAttributes();
    }

    @Override
    @Nullable
    public final List<Typeclass> getTypeclasses() {
        return this.column.getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public final List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @Nullable
    public final String getGroup() {
        return this.column.getGroup();
    }

    @Override
    public final IdentifiableColumn getColumn() {
        return this.column;
    }

    @Override
    public final HashFunctionType getHashFunctionType() {
        return this.hashFunctionType;
    }

    @Override
    @Nullable
    public final String getName() {
        return this.column.getName();
    }

    @Override
    @Unsafe
    @Nullable
    @JsonIgnore
    public final String getDescription() {
        return "Hash of " + this.column.getName();
    }

    @Override
    public final String getIdentifier() {
        return this.column.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashedColumnInfoV1 that = (HashedColumnInfoV1)obj;
        return Objects.equals(this.column, that.column) && this.hashFunctionType == that.hashFunctionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.hashFunctionType});
    }
}

