/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.ipaddress;

import com.palantir.logsafe.Arg;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.IpAddressBucket;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.ipaddress.IpAddressBucketColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class IpAddressBucketColumnInfoV1
implements IpAddressBucketColumnInfo {
    private final ColumnInfo column;
    private final IpAddressBucket ipAddressBucket;
    private final IpAddressBucketColumnInfo.IpAddressBucketFunctionTitle functionTitle;

    public IpAddressBucketColumnInfoV1(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="ipAddressBucket") IpAddressBucket ipAddressBucket, @JsonProperty(value="functionTitle") Optional<IpAddressBucketColumnInfo.IpAddressBucketFunctionTitle> functionTitle) {
        ContourExceptions.client400CheckNotNullWithSafeMessage(column, "column must not be null", new Arg[0]);
        ContourExceptions.client400CheckNotNullWithSafeMessage((Object)ipAddressBucket, "ipAddressBucket must not be null", new Arg[0]);
        ContourExceptions.client400CheckNotNullWithSafeMessage(functionTitle, "functionTitle must not be null.", new Arg[0]);
        this.column = column;
        this.ipAddressBucket = ipAddressBucket;
        this.functionTitle = functionTitle.orElse(IpAddressBucketColumnInfo.IpAddressBucketFunctionTitle.UDF);
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    public IpAddressBucket getIpAddressBucket() {
        return this.ipAddressBucket;
    }

    @Override
    public IpAddressBucketColumnInfo.IpAddressBucketFunctionTitle getFunctionTitle() {
        return this.functionTitle;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName() + "_" + this.ipAddressBucket.getDisplayName();
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return new HashSet<ColumnAttribute>(this.column.getAttributes());
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        if (this.getIpAddressBucket() == IpAddressBucket.NONE) {
            return this.getColumn().getTypeclasses();
        }
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        if (this.getIpAddressBucket() == IpAddressBucket.NONE) {
            return this.getColumn().getJoinMetadataList();
        }
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.ipAddressBucket, this.functionTitle});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddressBucketColumnInfo other = (IpAddressBucketColumnInfo)obj;
        return Objects.equals(this.column, other.getColumn()) && Objects.equals((Object)this.ipAddressBucket, (Object)other.getIpAddressBucket()) && Objects.equals((Object)this.functionTitle, (Object)other.getFunctionTitle());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("column", this.column).add("ipAddressBucket", (Object)this.ipAddressBucket).add("functionTitle", (Object)this.functionTitle).toString();
    }
}

