/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.join;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.column.join.JoinCardinality;
import latitude.api.column.join.JoinMetadata;
import latitude.api.join.JoinType;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JoinMetadata", generator="Immutables")
@Immutable
public final class ImmutableJoinMetadata
implements JoinMetadata {
    private final String title;
    private final JoinCardinality cardinality;
    private final JoinType type;
    private final ResourceIdentifier targetDataset;
    private final String targetColumn;

    private ImmutableJoinMetadata(String title, JoinCardinality cardinality, JoinType type, ResourceIdentifier targetDataset, String targetColumn) {
        this.title = Objects.requireNonNull(title, "title");
        this.cardinality = Objects.requireNonNull(cardinality, "cardinality");
        this.type = Objects.requireNonNull(type, "type");
        this.targetDataset = Objects.requireNonNull(targetDataset, "targetDataset");
        this.targetColumn = Objects.requireNonNull(targetColumn, "targetColumn");
    }

    private ImmutableJoinMetadata(ImmutableJoinMetadata original, String title, JoinCardinality cardinality, JoinType type, ResourceIdentifier targetDataset, String targetColumn) {
        this.title = title;
        this.cardinality = cardinality;
        this.type = type;
        this.targetDataset = targetDataset;
        this.targetColumn = targetColumn;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="cardinality")
    public JoinCardinality cardinality() {
        return this.cardinality;
    }

    @Override
    @JsonProperty(value="type")
    public JoinType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="targetDataset")
    public ResourceIdentifier targetDataset() {
        return this.targetDataset;
    }

    @Override
    @JsonProperty(value="targetColumn")
    public String targetColumn() {
        return this.targetColumn;
    }

    public final ImmutableJoinMetadata withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableJoinMetadata(this, newValue, this.cardinality, this.type, this.targetDataset, this.targetColumn);
    }

    public final ImmutableJoinMetadata withCardinality(JoinCardinality value) {
        JoinCardinality newValue = Objects.requireNonNull(value, "cardinality");
        if (this.cardinality == newValue) {
            return this;
        }
        return new ImmutableJoinMetadata(this, this.title, newValue, this.type, this.targetDataset, this.targetColumn);
    }

    public final ImmutableJoinMetadata withType(JoinType value) {
        JoinType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableJoinMetadata(this, this.title, this.cardinality, newValue, this.targetDataset, this.targetColumn);
    }

    public final ImmutableJoinMetadata withTargetDataset(ResourceIdentifier value) {
        if (this.targetDataset == value) {
            return this;
        }
        ResourceIdentifier newValue = Objects.requireNonNull(value, "targetDataset");
        return new ImmutableJoinMetadata(this, this.title, this.cardinality, this.type, newValue, this.targetColumn);
    }

    public final ImmutableJoinMetadata withTargetColumn(String value) {
        String newValue = Objects.requireNonNull(value, "targetColumn");
        if (this.targetColumn.equals(newValue)) {
            return this;
        }
        return new ImmutableJoinMetadata(this, this.title, this.cardinality, this.type, this.targetDataset, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinMetadata && this.equalTo(0, (ImmutableJoinMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableJoinMetadata another) {
        return this.title.equals(another.title) && this.cardinality.equals((Object)another.cardinality) && this.type.equals((Object)another.type) && this.targetDataset.equals(another.targetDataset) && this.targetColumn.equals(another.targetColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.cardinality.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.targetDataset.hashCode();
        h += (h << 5) + this.targetColumn.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JoinMetadata").omitNullValues().add("title", this.title).add("cardinality", (Object)this.cardinality).add("type", (Object)this.type).add("targetDataset", this.targetDataset).add("targetColumn", this.targetColumn).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJoinMetadata fromJson(Json json) {
        Builder builder = ImmutableJoinMetadata.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.cardinality != null) {
            builder.cardinality(json.cardinality);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.targetDataset != null) {
            builder.targetDataset(json.targetDataset);
        }
        if (json.targetColumn != null) {
            builder.targetColumn(json.targetColumn);
        }
        return builder.build();
    }

    public static ImmutableJoinMetadata of(String title, JoinCardinality cardinality, JoinType type, ResourceIdentifier targetDataset, String targetColumn) {
        return new ImmutableJoinMetadata(title, cardinality, type, targetDataset, targetColumn);
    }

    public static ImmutableJoinMetadata copyOf(JoinMetadata instance) {
        if (instance instanceof ImmutableJoinMetadata) {
            return (ImmutableJoinMetadata)instance;
        }
        return ImmutableJoinMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JoinMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_CARDINALITY = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_TARGET_DATASET = 8L;
        private static final long INIT_BIT_TARGET_COLUMN = 16L;
        private long initBits = 31L;
        @Nullable
        private String title;
        @Nullable
        private JoinCardinality cardinality;
        @Nullable
        private JoinType type;
        @Nullable
        private ResourceIdentifier targetDataset;
        @Nullable
        private String targetColumn;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JoinMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.title(instance.title());
            this.cardinality(instance.cardinality());
            this.type(instance.type());
            this.targetDataset(instance.targetDataset());
            this.targetColumn(instance.targetColumn());
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="cardinality")
        @CanIgnoreReturnValue
        public final Builder cardinality(JoinCardinality cardinality) {
            this.cardinality = Objects.requireNonNull(cardinality, "cardinality");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(JoinType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="targetDataset")
        @CanIgnoreReturnValue
        public final Builder targetDataset(ResourceIdentifier targetDataset) {
            this.targetDataset = Objects.requireNonNull(targetDataset, "targetDataset");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="targetColumn")
        @CanIgnoreReturnValue
        public final Builder targetColumn(String targetColumn) {
            this.targetColumn = Objects.requireNonNull(targetColumn, "targetColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableJoinMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoinMetadata(null, this.title, this.cardinality, this.type, this.targetDataset, this.targetColumn);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cardinality");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("targetDataset");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("targetColumn");
            }
            return "Cannot build JoinMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JoinMetadata", generator="Immutables")
    static final class Json
    implements JoinMetadata {
        @Nullable
        String title;
        @Nullable
        JoinCardinality cardinality;
        @Nullable
        JoinType type;
        @Nullable
        ResourceIdentifier targetDataset;
        @Nullable
        String targetColumn;

        Json() {
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="cardinality")
        public void setCardinality(JoinCardinality cardinality) {
            this.cardinality = cardinality;
        }

        @JsonProperty(value="type")
        public void setType(JoinType type) {
            this.type = type;
        }

        @JsonProperty(value="targetDataset")
        public void setTargetDataset(ResourceIdentifier targetDataset) {
            this.targetDataset = targetDataset;
        }

        @JsonProperty(value="targetColumn")
        public void setTargetColumn(String targetColumn) {
            this.targetColumn = targetColumn;
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JoinCardinality cardinality() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JoinType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceIdentifier targetDataset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String targetColumn() {
            throw new UnsupportedOperationException();
        }
    }
}

