/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.numericrange;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.ColumnInfoVisitor;
import latitude.api.column.numericrange.NumericRangeBucketColumnInfoV1;
import latitude.api.column.numericrange.Scale;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;

public interface NumericRangeBucketColumnInfo
extends ColumnInfo {
    public ColumnInfo getColumn();

    public OptionalDouble getMin();

    public OptionalDouble getMax();

    public int getNumBuckets();

    public Scale getScale();

    public boolean getReturnDetailedBucketInformation();

    @Override
    @JsonIgnore
    public String getName();

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes();

    @Override
    default public <T, V extends ColumnInfoVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static class NumericRangeBucketColumnInfoBuilder {
        private ColumnInfo column;
        private OptionalDouble min = OptionalDouble.empty();
        private OptionalDouble max = OptionalDouble.empty();
        private int numBuckets;
        private Scale scale;
        private Optional<Boolean> returnDetailedBucketInformation = Optional.empty();

        public static NumericRangeBucketColumnInfoBuilder create() {
            return new NumericRangeBucketColumnInfoBuilder();
        }

        public NumericRangeBucketColumnInfoBuilder column(ColumnInfo column2) {
            this.column = column2;
            return this;
        }

        public NumericRangeBucketColumnInfoBuilder min(double min2) {
            this.min = OptionalDouble.of(min2);
            return this;
        }

        public NumericRangeBucketColumnInfoBuilder max(double max2) {
            this.max = OptionalDouble.of(max2);
            return this;
        }

        public NumericRangeBucketColumnInfoBuilder numBuckets(int numBuckets2) {
            this.numBuckets = numBuckets2;
            return this;
        }

        public NumericRangeBucketColumnInfoBuilder scale(Scale scale2) {
            this.scale = scale2;
            return this;
        }

        public NumericRangeBucketColumnInfoBuilder returnDetailedBucketInformation(boolean returnDetailedBucketInformation2) {
            this.returnDetailedBucketInformation = Optional.of(returnDetailedBucketInformation2);
            return this;
        }

        public NumericRangeBucketColumnInfo build() {
            ContourExceptions.client400PreconditionWithSafeMessage(this.numBuckets > 0, "Number of buckets must be greater than 0.", new Arg[0]);
            return new NumericRangeBucketColumnInfoV1(Preconditions.checkNotNull(this.column, "column"), this.min, this.max, this.numBuckets, Preconditions.checkNotNull(this.scale, "scale"), this.returnDetailedBucketInformation);
        }
    }

    public static enum ScaleType {
        LINEAR,
        LOGARITHMIC;

    }
}

