/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.numericrange;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.numericrange.NumericRangeBucketColumnInfo;
import latitude.api.column.numericrange.Scale;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class NumericRangeBucketColumnInfoV1
implements NumericRangeBucketColumnInfo {
    private final ColumnInfo column;
    private final OptionalDouble min;
    private final OptionalDouble max;
    private final int numBuckets;
    private final Scale scale;
    private final boolean returnDetailedBucketInformation;

    @JsonCreator
    public NumericRangeBucketColumnInfoV1(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="min") OptionalDouble min, @JsonProperty(value="max") OptionalDouble max, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="scale") Scale scale, @JsonProperty(value="returnDetailedBucketInformation") Optional<Boolean> returnDetailedBucketInformation) {
        ContourExceptions.client400PreconditionWithSafeMessage(numBuckets > 0, "Number of buckets for range bucket column must be greater than 0.", new Arg[0]);
        ContourExceptions.client400PreconditionWithSafeMessage(!min.isPresent() || !max.isPresent() || max.getAsDouble() >= min.getAsDouble(), String.format("Badly formed numeric range: max (%s) < min (%s).", max, min), new Arg[0]);
        this.column = column;
        this.min = min;
        this.max = max;
        this.numBuckets = numBuckets;
        this.scale = Preconditions.checkNotNull(scale, "Scale must be defined");
        this.returnDetailedBucketInformation = returnDetailedBucketInformation.orElse(false);
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    public OptionalDouble getMin() {
        return this.min;
    }

    @Override
    public OptionalDouble getMax() {
        return this.max;
    }

    @Override
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    public Scale getScale() {
        return this.scale;
    }

    @Override
    public boolean getReturnDetailedBucketInformation() {
        return this.returnDetailedBucketInformation;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName();
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.column.getAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public int hashCode() {
        return Objects.hash(this.column, this.min, this.max, this.numBuckets, this.scale, this.returnDetailedBucketInformation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumericRangeBucketColumnInfoV1 that = (NumericRangeBucketColumnInfoV1)obj;
        return Objects.equals(this.getColumn(), that.getColumn()) && Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getMax(), that.getMax()) && this.getNumBuckets() == that.getNumBuckets() && Objects.equals(this.getScale(), that.getScale()) && this.getReturnDetailedBucketInformation() == that.getReturnDetailedBucketInformation();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("column", this.column).add("min", this.min).add("max", this.max).add("numBuckets", this.numBuckets).add("scale", this.scale).add("returnDetailedBucketInformation", this.returnDetailedBucketInformation).toString();
    }
}

