/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.parseddate;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.parseddate.ParsedDateColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ParsedDateColumnInfoV1
implements ParsedDateColumnInfo {
    private final IdentifiableColumn source;
    private final String format;
    private final Optional<String> timezone;

    @JsonCreator
    public ParsedDateColumnInfoV1(@JsonProperty(value="source") IdentifiableColumn source, @JsonProperty(value="format") String format, @JsonProperty(value="timezone") Optional<String> timezone) {
        this.source = source;
        this.format = format;
        this.timezone = timezone;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public IdentifiableColumn getSource() {
        return this.source;
    }

    @Override
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @Override
    @Nullable
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return ColumnAttribute.getDateTimeAttributes();
    }

    @Override
    @Nullable
    public List<Typeclass> getTypeclasses() {
        return this.source.getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public List<String> getSourceTables() {
        return this.source.getSourceTables();
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.source.getGroup();
    }

    @Override
    @Nullable
    public String getName() {
        return this.source.getName();
    }

    @Override
    @Nullable
    @JsonIgnore
    public String getDescription() {
        return this.source.getDescription();
    }

    @Override
    public String getIdentifier() {
        return this.source.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedDateColumnInfoV1 that = (ParsedDateColumnInfoV1)obj;
        return Objects.equals(this.source, that.source) && Objects.equals(this.format, that.format) && Objects.equals(this.timezone, that.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.format, this.timezone);
    }
}

