/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.parseddatetime;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.parseddatetime.ParsedDateTimeColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class ParsedDateTimeColumnInfoV1
implements ParsedDateTimeColumnInfo {
    private final ColumnInfo source;
    private final ColumnInfo timeZoneColumn;
    private final String timeZone;
    private final String format;
    private final String name;

    public ParsedDateTimeColumnInfoV1(@JsonProperty(value="source") ColumnInfo source, @Nullable @JsonProperty(value="timeZoneColumn") ColumnInfo timeZoneColumn, @Nullable @JsonProperty(value="timeZone") String timeZone, @JsonProperty(value="format") String format, @JsonProperty(value="name") Optional<String> name) {
        this.source = source;
        this.timeZoneColumn = timeZoneColumn;
        this.timeZone = timeZone;
        this.format = format;
        this.name = name.orElse(null);
    }

    @Override
    public ColumnInfo getSource() {
        return this.source;
    }

    @Override
    public ColumnInfo getTimeZoneColumn() {
        return this.timeZoneColumn;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        if (!Strings.isNullOrEmpty(this.name)) {
            return this.name;
        }
        return this.source.getName() + "_as_Date";
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.source.getDescription();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return ColumnAttribute.getDateTimeAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        ImmutableList.Builder sourceTables = ImmutableList.builder();
        sourceTables.addAll(this.source.getSourceTables());
        if (this.timeZoneColumn != null) {
            sourceTables.addAll(this.timeZoneColumn.getSourceTables());
        }
        return sourceTables.build();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.source.getGroup();
    }

    @Override
    public boolean isValid() {
        return this.source != null && this.format != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("timeZoneColumn", this.timeZoneColumn).add("timeZone", this.timeZone).add("format", this.format).add("name", this.name).toString();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.timeZoneColumn, this.timeZone, this.format, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedDateTimeColumnInfoV1 that = (ParsedDateTimeColumnInfoV1)obj;
        return Objects.equals(this.source, that.source) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.timeZoneColumn, that.timeZoneColumn) && Objects.equals(this.format, that.format) && Objects.equals(this.name, that.name);
    }
}

