/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.parsednumber;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.parsednumber.ParsedNumberColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.base.Strings;

public final class ParsedNumberColumnInfoV1
implements ParsedNumberColumnInfo {
    private final ColumnInfo source;
    private final boolean useCommaAsDecimalSeparator;
    private final String name;

    public ParsedNumberColumnInfoV1(@JsonProperty(value="source") ColumnInfo source, @JsonProperty(value="useCommaAsDecimalSeparator") boolean useCommaAsDecimalSeparator, @JsonProperty(value="name") Optional<String> name) {
        this.useCommaAsDecimalSeparator = useCommaAsDecimalSeparator;
        this.source = source;
        this.name = name.orElse(null);
    }

    @Override
    public ColumnInfo getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        if (!Strings.isNullOrEmpty(this.name) || !this.isValid()) {
            return this.name;
        }
        return this.source.getName() + "_as_Number";
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.source.getDescription();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return ColumnAttribute.getNumberAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.source.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.source.getGroup();
    }

    @Override
    public boolean getUseCommaAsDecimalSeparator() {
        return this.useCommaAsDecimalSeparator;
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        return this.source != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("useCommaAsDecimalSeparator", this.useCommaAsDecimalSeparator).add("name", this.name).toString();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.useCommaAsDecimalSeparator, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedNumberColumnInfoV1 that = (ParsedNumberColumnInfoV1)obj;
        return Objects.equals(this.source, that.source) && this.useCommaAsDecimalSeparator == that.useCommaAsDecimalSeparator && Objects.equals(this.name, that.name);
    }
}

