/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.resolving;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.resolving.Resolution;
import latitude.api.column.resolving.ResolvingColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class ResolvingColumnInfoV1
implements ResolvingColumnInfo {
    private final ColumnInfo column;
    private final List<Resolution<String>> resolutions;

    public ResolvingColumnInfoV1(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="resolutions") List<Resolution<String>> resolutions) {
        this.column = column;
        this.resolutions = resolutions;
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    public List<Resolution<String>> getResolutions() {
        return this.resolutions;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName();
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.column.getDescription();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.column.getAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.getColumn().getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("column", this.column).add("resolutions", this.resolutions).toString();
    }

    public int hashCode() {
        return Objects.hash(this.column, this.resolutions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvingColumnInfo other = (ResolvingColumnInfo)obj;
        return Objects.equals(this.getColumn(), other.getColumn()) && Objects.equals(this.getResolutions(), other.getResolutions());
    }
}

