/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.retyped;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.basic.type.ContourFieldType;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.retyped.ColumnDataType;
import latitude.api.column.retyped.RetypedColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class RetypedColumnInfoV1
implements RetypedColumnInfo {
    private final IdentifiableColumn column;
    private final ColumnDataType newType;

    public RetypedColumnInfoV1(@JsonProperty(value="column") IdentifiableColumn column, @JsonProperty(value="newType") ColumnDataType newType) {
        this.column = column;
        this.newType = newType;
    }

    @Override
    public IdentifiableColumn getColumn() {
        return this.column;
    }

    @Override
    public ColumnDataType getNewType() {
        return this.newType;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName();
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.column.getDescription();
    }

    @Override
    public Set<ColumnAttribute> getAttributes() {
        switch (this.newType) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return ColumnAttribute.getNumberAttributes();
            }
            case DATE: {
                return ColumnAttribute.getLocalDateAttributes();
            }
            case TIMESTAMP: {
                return ColumnAttribute.getDateTimeAttributes();
            }
        }
        return Collections.emptySet();
    }

    @Override
    @JsonIgnore
    public ContourFieldType getFoundryFieldType() {
        switch (this.newType) {
            case BOOLEAN: {
                return ContourFieldType.BOOLEAN;
            }
            case INTEGER: {
                return ContourFieldType.INTEGER;
            }
            case FLOAT: {
                return ContourFieldType.FLOAT;
            }
            case DECIMAL: {
                return ContourFieldType.DECIMAL;
            }
            case TIMESTAMP: {
                return ContourFieldType.TIMESTAMP;
            }
            case DATE: {
                return ContourFieldType.DATE;
            }
            case LONG: {
                return ContourFieldType.LONG;
            }
            case BINARY: {
                return ContourFieldType.BINARY;
            }
            case STRING: {
                return ContourFieldType.STRING;
            }
            case SHORT: {
                return ContourFieldType.SHORT;
            }
            case DOUBLE: {
                return ContourFieldType.DOUBLE;
            }
            case BYTE: {
                return ContourFieldType.BYTE;
            }
        }
        throw ContourExceptions.server500IllegalEnum(this.newType);
    }

    @Override
    @Nullable
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.column.getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @Nullable
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        return this.column.getIdentifier();
    }

    public String toString() {
        return "RetypedColumnInfoV1{column=" + this.column + ", newType=" + this.newType + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RetypedColumnInfoV1 that = (RetypedColumnInfoV1)obj;
        return Objects.equals(this.column, that.column) && this.newType == that.newType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.newType});
    }
}

