/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.shifting;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Unsafe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.shifting.ShiftingColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class ShiftingColumnInfoV1
implements ShiftingColumnInfo {
    private final ColumnInfo column;
    private final int shift;

    @JsonCreator
    public ShiftingColumnInfoV1(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="shift") int shift) {
        ContourExceptions.client400PreconditionWithSafeMessage(shift >= 0, "Shouldn't shift by a negative amount.", new Arg[0]);
        this.column = column;
        this.shift = shift;
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName();
    }

    @Override
    @Unsafe
    @JsonIgnore
    public String getDescription() {
        return this.column.getName() + " shifted by " + this.shift;
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.column.getAttributes();
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.getColumn().getTypeclasses();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("column", this.column).add("shift", this.shift).toString();
    }

    public int hashCode() {
        return Objects.hash(this.column, this.shift);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShiftingColumnInfo other = (ShiftingColumnInfo)obj;
        return Objects.equals(this.getColumn(), other.getColumn()) && this.getShift() == other.getShift();
    }
}

