/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.time;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.TimeBucket;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.time.TimeBucketColumnInfo;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.exception.ContourExceptions;
import latitude.api.util.TimeZones;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.common.base.MoreObjects;

public final class TimeBucketColumnInfoV1
implements TimeBucketColumnInfo {
    private static final SafeLogger log = SafeLoggerFactory.get(TimeBucketColumnInfoV1.class);
    private final ColumnInfo column;
    private final TimeBucket timeBucket;
    private final String timeZone;
    private final TimeBucketColumnInfo.TimeBucketFunctionTitle functionTitle;

    public TimeBucketColumnInfoV1(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="timeBucket") TimeBucket timeBucket, @JsonProperty(value="timeZone") String timeZone, @JsonProperty(value="functionTitle") Optional<TimeBucketColumnInfo.TimeBucketFunctionTitle> functionTitle) {
        ContourExceptions.client400CheckNotNullWithSafeMessage(column, "column must not be null.", new Arg[0]);
        ContourExceptions.client400CheckNotNullWithSafeMessage((Object)timeBucket, "timeBucket must not be null.", new Arg[0]);
        ContourExceptions.client400CheckNotNullWithSafeMessage(functionTitle, "functionTitle must not be null.", new Arg[0]);
        if (column.getAttributes() == null || !column.getAttributes().contains((Object)ColumnAttribute.TIME)) {
            log.warn("Only columns with the 'time' attribute should be bucketable. Missing 'time' attribute: {}", UnsafeArg.of("columnName", column.getName()));
        }
        this.column = column;
        this.timeBucket = timeBucket;
        this.timeZone = TimeZones.validateAndNormalizeTimezone(timeZone, column.getName());
        this.functionTitle = functionTitle.orElse(TimeBucketColumnInfo.TimeBucketFunctionTitle.UDF);
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column;
    }

    @Override
    public TimeBucket getTimeBucket() {
        return this.timeBucket;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public TimeBucketColumnInfo.TimeBucketFunctionTitle getFunctionTitle() {
        return this.functionTitle;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.column.getName() + "_" + this.timeBucket.getDisplayName();
    }

    @Override
    @Unsafe
    @JsonIgnore
    public String getDescription() {
        return this.column.getName() + " bucketed by " + this.timeBucket.getDisplayName();
    }

    @Override
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        HashSet<ColumnAttribute> attributes = new HashSet<ColumnAttribute>(this.column.getAttributes());
        if (this.timeBucket.isOrdinal()) {
            attributes.remove((Object)ColumnAttribute.TIME);
            attributes.remove((Object)ColumnAttribute.DATE);
            attributes.addAll(ColumnAttribute.getNumberAttributes());
        }
        return attributes;
    }

    @Override
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        if (this.getTimeBucket() == TimeBucket.NONE) {
            return this.getColumn().getTypeclasses();
        }
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        if (this.getTimeBucket() == TimeBucket.NONE) {
            return this.getColumn().getJoinMetadataList();
        }
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.getSourceTables();
    }

    @Override
    @JsonIgnore
    public String getGroup() {
        return this.column.getGroup();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("column", this.column).add("timeBucket", (Object)this.timeBucket).add("timeZone", this.timeZone).add("functionTitle", (Object)this.functionTitle).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.timeBucket, this.timeZone, this.functionTitle});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeBucketColumnInfo other = (TimeBucketColumnInfo)obj;
        return Objects.equals(this.getColumn(), other.getColumn()) && Objects.equals((Object)this.getTimeBucket(), (Object)other.getTimeBucket()) && Objects.equals(this.getTimeZone(), other.getTimeZone()) && Objects.equals((Object)this.getFunctionTitle(), (Object)other.getFunctionTitle());
    }
}

