/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.column.windowfunction;

import com.palantir.logsafe.Arg;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.aggregates.LatitudeAggregate;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.column.join.JoinMetadata;
import latitude.api.column.typeclass.Typeclass;
import latitude.api.column.windowfunction.WindowFunctionColumnInfo;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class WindowFunctionColumnInfoV1
implements WindowFunctionColumnInfo {
    private final LatitudeAggregate.AggregateType aggregateType;
    private final Optional<ColumnInfo> column;
    private final Optional<String> identifier;
    private final Optional<ColumnInfo> orderBy;
    private final Optional<ColumnInfo> partitionBy;
    private final String windowStart;
    private final String windowEnd;

    public WindowFunctionColumnInfoV1(@JsonProperty(value="aggregateType") LatitudeAggregate.AggregateType aggregateType, @Nullable @JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="name") String identifier, @Nullable @JsonProperty(value="orderBy") ColumnInfo orderBy, @Nullable @JsonProperty(value="partitionBy") ColumnInfo partionBy, @JsonProperty(value="windowStart") String windowStart, @JsonProperty(value="windowEnd") String windowEnd) {
        ContourExceptions.client400PreconditionWithSafeMessage(windowStart == null && windowEnd == null || windowStart != null && windowEnd != null, String.format("Window function must have BOTH start and end boundaries, or neither. Missing: %s.", windowStart == null ? "start boundary" : "end boundary"), new Arg[0]);
        this.aggregateType = aggregateType;
        this.column = Optional.ofNullable(column);
        this.identifier = Optional.ofNullable(identifier);
        this.orderBy = Optional.ofNullable(orderBy);
        this.partitionBy = Optional.ofNullable(partionBy);
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
    }

    private Optional<Long> parseNullableLong(String windowBound) {
        if (windowBound == null) {
            return Optional.empty();
        }
        return Optional.of(Long.valueOf(windowBound));
    }

    @Override
    public boolean isValid() {
        return this.aggregateType != null && this.column.isPresent() && this.identifier.isPresent() && this.orderBy.isPresent();
    }

    @Override
    public LatitudeAggregate.AggregateType getAggregateType() {
        return this.aggregateType;
    }

    @Override
    public ColumnInfo getColumn() {
        return this.column.orElse(null);
    }

    @Override
    public Optional<ColumnInfo> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Optional<ColumnInfo> getPartitionBy() {
        return this.partitionBy;
    }

    @Override
    public String getWindowStart() {
        return this.windowStart;
    }

    @Override
    @JsonIgnore
    public Optional<Long> getWindowStartLong() {
        return this.parseNullableLong(this.windowStart);
    }

    @Override
    public String getWindowEnd() {
        return this.windowEnd;
    }

    @Override
    @JsonIgnore
    public Optional<Long> getWindowEndLong() {
        return this.parseNullableLong(this.windowEnd);
    }

    @Override
    @Nullable
    public String getName() {
        return this.identifier.orElse(null);
    }

    @Override
    @Nullable
    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @Override
    @Nullable
    @JsonIgnore
    public Set<ColumnAttribute> getAttributes() {
        return this.column.isPresent() ? this.column.get().getAttributes() : null;
    }

    @Override
    @Nullable
    @JsonIgnore
    public List<Typeclass> getTypeclasses() {
        return this.column.isPresent() ? this.column.get().getTypeclasses() : null;
    }

    @Override
    @JsonIgnore
    public List<JoinMetadata> getJoinMetadataList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    @JsonIgnore
    public List<String> getSourceTables() {
        return this.column.isPresent() ? this.column.get().getSourceTables() : null;
    }

    @Override
    @Nullable
    @JsonIgnore
    public String getGroup() {
        return this.column.isPresent() ? this.column.get().getGroup() : null;
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        return this.identifier.orElse(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFunctionColumnInfoV1 that = (WindowFunctionColumnInfoV1)obj;
        return this.aggregateType == that.aggregateType && Objects.equals(this.column, that.column) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.partitionBy, that.partitionBy) && Objects.equals(this.windowStart, that.windowStart) && Objects.equals(this.windowEnd, that.windowEnd);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregateType, this.column, this.identifier, this.orderBy, this.partitionBy, this.windowStart, this.windowEnd});
    }
}

