/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.description.LatitudeCipherSetDescription;
import latitude.api.description.LatitudeSetDescription;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.bellaso.api.RequestType;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LatitudeCipherSetDescription", generator="Immutables")
@Immutable
public final class ImmutableLatitudeCipherSetDescription
implements LatitudeCipherSetDescription {
    private final LatitudeSetDescription parent;
    private final RequestType cipherRequestType;
    private final ResourceIdentifier cipherLicenseRid;
    private final String column;
    @Nullable
    private final ResourceIdentifier cipherCrypterRid;

    private ImmutableLatitudeCipherSetDescription(LatitudeSetDescription parent, RequestType cipherRequestType, ResourceIdentifier cipherLicenseRid, String column, @Nullable ResourceIdentifier cipherCrypterRid) {
        this.parent = parent;
        this.cipherRequestType = cipherRequestType;
        this.cipherLicenseRid = cipherLicenseRid;
        this.column = column;
        this.cipherCrypterRid = cipherCrypterRid;
    }

    @Override
    @JsonProperty(value="parent")
    public LatitudeSetDescription getParent() {
        return this.parent;
    }

    @Override
    @JsonProperty(value="cipherRequestType")
    public RequestType getCipherRequestType() {
        return this.cipherRequestType;
    }

    @Override
    @JsonProperty(value="cipherLicenseRid")
    public ResourceIdentifier getCipherLicenseRid() {
        return this.cipherLicenseRid;
    }

    @Override
    @JsonProperty(value="column")
    public String getColumn() {
        return this.column;
    }

    @Override
    @JsonProperty(value="cipherCrypterRid")
    public Optional<ResourceIdentifier> getCipherCrypterRid() {
        return Optional.ofNullable(this.cipherCrypterRid);
    }

    public final ImmutableLatitudeCipherSetDescription withParent(LatitudeSetDescription value) {
        if (this.parent == value) {
            return this;
        }
        LatitudeSetDescription newValue = Objects.requireNonNull(value, "parent");
        return new ImmutableLatitudeCipherSetDescription(newValue, this.cipherRequestType, this.cipherLicenseRid, this.column, this.cipherCrypterRid);
    }

    public final ImmutableLatitudeCipherSetDescription withCipherRequestType(RequestType value) {
        if (this.cipherRequestType == value) {
            return this;
        }
        RequestType newValue = Objects.requireNonNull(value, "cipherRequestType");
        return new ImmutableLatitudeCipherSetDescription(this.parent, newValue, this.cipherLicenseRid, this.column, this.cipherCrypterRid);
    }

    public final ImmutableLatitudeCipherSetDescription withCipherLicenseRid(ResourceIdentifier value) {
        if (this.cipherLicenseRid == value) {
            return this;
        }
        ResourceIdentifier newValue = Objects.requireNonNull(value, "cipherLicenseRid");
        return new ImmutableLatitudeCipherSetDescription(this.parent, this.cipherRequestType, newValue, this.column, this.cipherCrypterRid);
    }

    public final ImmutableLatitudeCipherSetDescription withColumn(String value) {
        String newValue = Objects.requireNonNull(value, "column");
        if (this.column.equals(newValue)) {
            return this;
        }
        return new ImmutableLatitudeCipherSetDescription(this.parent, this.cipherRequestType, this.cipherLicenseRid, newValue, this.cipherCrypterRid);
    }

    public final ImmutableLatitudeCipherSetDescription withCipherCrypterRid(ResourceIdentifier value) {
        ResourceIdentifier newValue = Objects.requireNonNull(value, "cipherCrypterRid");
        if (this.cipherCrypterRid == newValue) {
            return this;
        }
        return new ImmutableLatitudeCipherSetDescription(this.parent, this.cipherRequestType, this.cipherLicenseRid, this.column, newValue);
    }

    public final ImmutableLatitudeCipherSetDescription withCipherCrypterRid(Optional<? extends ResourceIdentifier> optional) {
        ResourceIdentifier value = optional.orElse(null);
        if (this.cipherCrypterRid == value) {
            return this;
        }
        return new ImmutableLatitudeCipherSetDescription(this.parent, this.cipherRequestType, this.cipherLicenseRid, this.column, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLatitudeCipherSetDescription && this.equalTo(0, (ImmutableLatitudeCipherSetDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableLatitudeCipherSetDescription another) {
        return this.parent.equals(another.parent) && this.cipherRequestType.equals(another.cipherRequestType) && this.cipherLicenseRid.equals(another.cipherLicenseRid) && this.column.equals(another.column) && Objects.equals(this.cipherCrypterRid, another.cipherCrypterRid);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parent.hashCode();
        h += (h << 5) + this.cipherRequestType.hashCode();
        h += (h << 5) + this.cipherLicenseRid.hashCode();
        h += (h << 5) + this.column.hashCode();
        h += (h << 5) + Objects.hashCode(this.cipherCrypterRid);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LatitudeCipherSetDescription").omitNullValues().add("parent", this.parent).add("cipherRequestType", this.cipherRequestType).add("cipherLicenseRid", this.cipherLicenseRid).add("column", this.column).add("cipherCrypterRid", this.cipherCrypterRid).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLatitudeCipherSetDescription fromJson(Json json) {
        LatitudeCipherSetDescription.Builder builder = new LatitudeCipherSetDescription.Builder();
        if (json.parent != null) {
            builder.parent(json.parent);
        }
        if (json.cipherRequestType != null) {
            builder.cipherRequestType(json.cipherRequestType);
        }
        if (json.cipherLicenseRid != null) {
            builder.cipherLicenseRid(json.cipherLicenseRid);
        }
        if (json.column != null) {
            builder.column(json.column);
        }
        if (json.cipherCrypterRid != null) {
            builder.cipherCrypterRid(json.cipherCrypterRid);
        }
        return builder.build();
    }

    public static ImmutableLatitudeCipherSetDescription copyOf(LatitudeCipherSetDescription instance) {
        if (instance instanceof ImmutableLatitudeCipherSetDescription) {
            return (ImmutableLatitudeCipherSetDescription)instance;
        }
        return new LatitudeCipherSetDescription.Builder().from(instance).build();
    }

    @Generated(from="LatitudeCipherSetDescription", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_PARENT = 1L;
        private static final long INIT_BIT_CIPHER_REQUEST_TYPE = 2L;
        private static final long INIT_BIT_CIPHER_LICENSE_RID = 4L;
        private static final long INIT_BIT_COLUMN = 8L;
        private long initBits = 15L;
        @Nullable
        private LatitudeSetDescription parent;
        @Nullable
        private RequestType cipherRequestType;
        @Nullable
        private ResourceIdentifier cipherLicenseRid;
        @Nullable
        private String column;
        @Nullable
        private ResourceIdentifier cipherCrypterRid;

        public Builder() {
            if (!(this instanceof LatitudeCipherSetDescription.Builder)) {
                throw new UnsupportedOperationException("Use: new LatitudeCipherSetDescription.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder from(LatitudeCipherSetDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.parent(instance.getParent());
            this.cipherRequestType(instance.getCipherRequestType());
            this.cipherLicenseRid(instance.getCipherLicenseRid());
            this.column(instance.getColumn());
            Optional<ResourceIdentifier> cipherCrypterRidOptional = instance.getCipherCrypterRid();
            if (cipherCrypterRidOptional.isPresent()) {
                this.cipherCrypterRid(cipherCrypterRidOptional);
            }
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @JsonProperty(value="parent")
        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder parent(LatitudeSetDescription parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @JsonProperty(value="cipherRequestType")
        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder cipherRequestType(RequestType cipherRequestType) {
            this.cipherRequestType = Objects.requireNonNull(cipherRequestType, "cipherRequestType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @JsonProperty(value="cipherLicenseRid")
        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder cipherLicenseRid(ResourceIdentifier cipherLicenseRid) {
            this.cipherLicenseRid = Objects.requireNonNull(cipherLicenseRid, "cipherLicenseRid");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @JsonProperty(value="column")
        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder column(String column) {
            this.column = Objects.requireNonNull(column, "column");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder cipherCrypterRid(ResourceIdentifier cipherCrypterRid) {
            this.cipherCrypterRid = Objects.requireNonNull(cipherCrypterRid, "cipherCrypterRid");
            return (LatitudeCipherSetDescription.Builder)this;
        }

        @JsonProperty(value="cipherCrypterRid")
        @CanIgnoreReturnValue
        public final LatitudeCipherSetDescription.Builder cipherCrypterRid(Optional<? extends ResourceIdentifier> cipherCrypterRid) {
            this.cipherCrypterRid = cipherCrypterRid.orElse(null);
            return (LatitudeCipherSetDescription.Builder)this;
        }

        public ImmutableLatitudeCipherSetDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLatitudeCipherSetDescription(this.parent, this.cipherRequestType, this.cipherLicenseRid, this.column, this.cipherCrypterRid);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("parent");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cipherRequestType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("cipherLicenseRid");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("column");
            }
            return "Cannot build LatitudeCipherSetDescription, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LatitudeCipherSetDescription", generator="Immutables")
    static final class Json
    implements LatitudeCipherSetDescription {
        @Nullable
        LatitudeSetDescription parent;
        @Nullable
        RequestType cipherRequestType;
        @Nullable
        ResourceIdentifier cipherLicenseRid;
        @Nullable
        String column;
        @Nullable
        Optional<ResourceIdentifier> cipherCrypterRid = Optional.empty();

        Json() {
        }

        @JsonProperty(value="parent")
        public void setParent(LatitudeSetDescription parent) {
            this.parent = parent;
        }

        @JsonProperty(value="cipherRequestType")
        public void setCipherRequestType(RequestType cipherRequestType) {
            this.cipherRequestType = cipherRequestType;
        }

        @JsonProperty(value="cipherLicenseRid")
        public void setCipherLicenseRid(ResourceIdentifier cipherLicenseRid) {
            this.cipherLicenseRid = cipherLicenseRid;
        }

        @JsonProperty(value="column")
        public void setColumn(String column) {
            this.column = column;
        }

        @JsonProperty(value="cipherCrypterRid")
        public void setCipherCrypterRid(Optional<ResourceIdentifier> cipherCrypterRid) {
            this.cipherCrypterRid = cipherCrypterRid;
        }

        @Override
        public LatitudeSetDescription getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RequestType getCipherRequestType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceIdentifier getCipherLicenseRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResourceIdentifier> getCipherCrypterRid() {
            throw new UnsupportedOperationException();
        }
    }
}

