/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.description.LatitudeTableSetDescription;
import latitude.api.path.TableRid;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonFormat;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LatitudeTableSetDescription", generator="Immutables")
@Immutable
public final class ImmutableLatitudeTableSetDescription
implements LatitudeTableSetDescription {
    private final TableRid tableRid;
    private final String branch;
    private final OffsetDateTime asof;
    private final boolean allowQueryingLaterThanAsOf;
    private volatile transient long lazyInitBitmap;
    private static final long ASOF_TO_QUERY_LAZY_INIT_BIT = 1L;
    private transient Optional<OffsetDateTime> asofToQuery;

    private ImmutableLatitudeTableSetDescription(Builder builder) {
        this.tableRid = builder.tableRid;
        this.branch = builder.branch;
        this.asof = builder.asof;
        this.allowQueryingLaterThanAsOf = builder.allowQueryingLaterThanAsOfIsSet() ? builder.allowQueryingLaterThanAsOf : LatitudeTableSetDescription.super.allowQueryingLaterThanAsOf();
    }

    private ImmutableLatitudeTableSetDescription(TableRid tableRid, String branch, OffsetDateTime asof, boolean allowQueryingLaterThanAsOf) {
        this.tableRid = tableRid;
        this.branch = branch;
        this.asof = asof;
        this.allowQueryingLaterThanAsOf = allowQueryingLaterThanAsOf;
    }

    @Override
    @JsonProperty(value="tableRid")
    public TableRid tableRid() {
        return this.tableRid;
    }

    @Override
    @JsonProperty(value="branch")
    public String branch() {
        return this.branch;
    }

    @Override
    @JsonProperty(value="asof")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ")
    public OffsetDateTime asof() {
        return this.asof;
    }

    @Override
    @JsonProperty(value="allowQueryingLaterThanAsOf")
    public boolean allowQueryingLaterThanAsOf() {
        return this.allowQueryingLaterThanAsOf;
    }

    public final ImmutableLatitudeTableSetDescription withTableRid(TableRid value) {
        if (this.tableRid == value) {
            return this;
        }
        TableRid newValue = Objects.requireNonNull(value, "tableRid");
        return new ImmutableLatitudeTableSetDescription(newValue, this.branch, this.asof, this.allowQueryingLaterThanAsOf);
    }

    public final ImmutableLatitudeTableSetDescription withBranch(String value) {
        String newValue = Objects.requireNonNull(value, "branch");
        if (this.branch.equals(newValue)) {
            return this;
        }
        return new ImmutableLatitudeTableSetDescription(this.tableRid, newValue, this.asof, this.allowQueryingLaterThanAsOf);
    }

    public final ImmutableLatitudeTableSetDescription withAsof(OffsetDateTime value) {
        if (this.asof == value) {
            return this;
        }
        OffsetDateTime newValue = Objects.requireNonNull(value, "asof");
        return new ImmutableLatitudeTableSetDescription(this.tableRid, this.branch, newValue, this.allowQueryingLaterThanAsOf);
    }

    public final ImmutableLatitudeTableSetDescription withAllowQueryingLaterThanAsOf(boolean value) {
        if (this.allowQueryingLaterThanAsOf == value) {
            return this;
        }
        return new ImmutableLatitudeTableSetDescription(this.tableRid, this.branch, this.asof, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLatitudeTableSetDescription && this.equalTo(0, (ImmutableLatitudeTableSetDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableLatitudeTableSetDescription another) {
        return this.tableRid.equals(another.tableRid) && this.branch.equals(another.branch) && this.asof.equals(another.asof) && this.allowQueryingLaterThanAsOf == another.allowQueryingLaterThanAsOf;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tableRid.hashCode();
        h += (h << 5) + this.branch.hashCode();
        h += (h << 5) + this.asof.hashCode();
        h += (h << 5) + Booleans.hashCode(this.allowQueryingLaterThanAsOf);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LatitudeTableSetDescription").omitNullValues().add("tableRid", this.tableRid).add("branch", this.branch).add("asof", this.asof).add("allowQueryingLaterThanAsOf", this.allowQueryingLaterThanAsOf).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLatitudeTableSetDescription fromJson(Json json) {
        LatitudeTableSetDescription.Builder builder = new LatitudeTableSetDescription.Builder();
        if (json.tableRid != null) {
            builder.tableRid(json.tableRid);
        }
        if (json.branch != null) {
            builder.branch(json.branch);
        }
        if (json.asof != null) {
            builder.asof(json.asof);
        }
        if (json.allowQueryingLaterThanAsOfIsSet) {
            builder.allowQueryingLaterThanAsOf(json.allowQueryingLaterThanAsOf);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<OffsetDateTime> asofToQuery() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLatitudeTableSetDescription immutableLatitudeTableSetDescription = this;
            synchronized (immutableLatitudeTableSetDescription) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.asofToQuery = Objects.requireNonNull(LatitudeTableSetDescription.super.asofToQuery(), "asofToQuery");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.asofToQuery;
    }

    public static ImmutableLatitudeTableSetDescription copyOf(LatitudeTableSetDescription instance) {
        if (instance instanceof ImmutableLatitudeTableSetDescription) {
            return (ImmutableLatitudeTableSetDescription)instance;
        }
        return new LatitudeTableSetDescription.Builder().from(instance).build();
    }

    @Generated(from="LatitudeTableSetDescription", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_TABLE_RID = 1L;
        private static final long INIT_BIT_BRANCH = 2L;
        private static final long INIT_BIT_ASOF = 4L;
        private static final long OPT_BIT_ALLOW_QUERYING_LATER_THAN_AS_OF = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private TableRid tableRid;
        @Nullable
        private String branch;
        @Nullable
        private OffsetDateTime asof;
        private boolean allowQueryingLaterThanAsOf;

        public Builder() {
            if (!(this instanceof LatitudeTableSetDescription.Builder)) {
                throw new UnsupportedOperationException("Use: new LatitudeTableSetDescription.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final LatitudeTableSetDescription.Builder from(LatitudeTableSetDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.tableRid(instance.tableRid());
            this.branch(instance.branch());
            this.asof(instance.asof());
            this.allowQueryingLaterThanAsOf(instance.allowQueryingLaterThanAsOf());
            return (LatitudeTableSetDescription.Builder)this;
        }

        @JsonProperty(value="tableRid")
        @CanIgnoreReturnValue
        public final LatitudeTableSetDescription.Builder tableRid(TableRid tableRid) {
            this.tableRid = Objects.requireNonNull(tableRid, "tableRid");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (LatitudeTableSetDescription.Builder)this;
        }

        @JsonProperty(value="branch")
        @CanIgnoreReturnValue
        public final LatitudeTableSetDescription.Builder branch(String branch) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (LatitudeTableSetDescription.Builder)this;
        }

        @JsonProperty(value="asof")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ")
        @CanIgnoreReturnValue
        public final LatitudeTableSetDescription.Builder asof(OffsetDateTime asof) {
            this.asof = Objects.requireNonNull(asof, "asof");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (LatitudeTableSetDescription.Builder)this;
        }

        @JsonProperty(value="allowQueryingLaterThanAsOf")
        @CanIgnoreReturnValue
        public final LatitudeTableSetDescription.Builder allowQueryingLaterThanAsOf(boolean allowQueryingLaterThanAsOf) {
            this.allowQueryingLaterThanAsOf = allowQueryingLaterThanAsOf;
            this.optBits |= 1L;
            return (LatitudeTableSetDescription.Builder)this;
        }

        public ImmutableLatitudeTableSetDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLatitudeTableSetDescription(this);
        }

        private boolean allowQueryingLaterThanAsOfIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableRid");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("branch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("asof");
            }
            return "Cannot build LatitudeTableSetDescription, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LatitudeTableSetDescription", generator="Immutables")
    static final class Json
    implements LatitudeTableSetDescription {
        @Nullable
        TableRid tableRid;
        @Nullable
        String branch;
        @Nullable
        OffsetDateTime asof;
        boolean allowQueryingLaterThanAsOf;
        boolean allowQueryingLaterThanAsOfIsSet;

        Json() {
        }

        @JsonProperty(value="tableRid")
        public void setTableRid(TableRid tableRid) {
            this.tableRid = tableRid;
        }

        @JsonProperty(value="branch")
        public void setBranch(String branch) {
            this.branch = branch;
        }

        @JsonProperty(value="asof")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ")
        public void setAsof(OffsetDateTime asof) {
            this.asof = asof;
        }

        @JsonProperty(value="allowQueryingLaterThanAsOf")
        public void setAllowQueryingLaterThanAsOf(boolean allowQueryingLaterThanAsOf) {
            this.allowQueryingLaterThanAsOf = allowQueryingLaterThanAsOf;
            this.allowQueryingLaterThanAsOfIsSet = true;
        }

        @Override
        public TableRid tableRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String branch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime asof() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean allowQueryingLaterThanAsOf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OffsetDateTime> asofToQuery() {
            throw new UnsupportedOperationException();
        }
    }
}

