/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import latitude.api.aggregates.LatitudeAggregate;
import latitude.api.aggregates.LatitudeAggregateOperator;
import latitude.api.aggregates.LatitudeGroupBy;
import latitude.api.column.ColumnInfo;
import latitude.api.column.basic.BasicColumnInfo;
import latitude.api.description.LatitudeAggregateSetDescription;
import latitude.api.description.LatitudeFilterSetDescription;
import latitude.api.description.LatitudeJoinSetDescription;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.filter.LatitudeFilter;
import latitude.api.join.AllColumnsColumnList;
import latitude.api.join.ExplicitColumnList;
import latitude.api.join.JoinType;
import latitude.api.join.MatchType;
import latitude.api.join.MatchTypeV1;
import latitude.api.join.Term;
import latitude.api.join.TermV1;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class LatitudeAggregateFilterSetDescription
implements LatitudeSetDescription {
    private final LatitudeSetDescription setToFilter;
    private final List<LatitudeGroupBy> groupBy;
    private final List<LatitudeAggregate> aggregates;
    private final LatitudeFilter filter;

    @JsonCreator
    public LatitudeAggregateFilterSetDescription(@JsonProperty(value="setToFilter") LatitudeSetDescription setToFilter, @JsonProperty(value="groupBy") List<LatitudeGroupBy> groupBy, @JsonProperty(value="aggregates") List<LatitudeAggregate> aggregates, @JsonProperty(value="filter") LatitudeFilter filter) {
        this.setToFilter = setToFilter;
        this.groupBy = groupBy;
        this.aggregates = aggregates;
        this.filter = filter;
    }

    public LatitudeSetDescription getSetToFilter() {
        return this.setToFilter;
    }

    public List<LatitudeGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public List<LatitudeAggregate> getAggregates() {
        return this.aggregates;
    }

    public LatitudeFilter getFilter() {
        return this.filter;
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.setToFilter, this.groupBy, this.aggregates, this.filter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudeAggregateFilterSetDescription that = (LatitudeAggregateFilterSetDescription)obj;
        return Objects.equals(this.setToFilter, that.setToFilter) && Objects.equals(this.groupBy, that.groupBy) && Objects.equals(this.aggregates, that.aggregates) && Objects.equals(this.filter, that.filter);
    }

    public String toString() {
        return "LatitudeAggregateFilterSetDescription{setToFilter=" + this.setToFilter + ", groupBy=" + this.groupBy + ", aggregates=" + this.aggregates + ", filter=" + this.filter + "}";
    }

    @JsonIgnore
    public LatitudeJoinSetDescription asLatitudeJoinedSetDescription() {
        LatitudeFilterSetDescription filteredAggregateSet = new LatitudeFilterSetDescription(new LatitudeAggregateSetDescription(this.setToFilter, this.groupBy, this.aggregates, Optional.empty(), Optional.of(LatitudeAggregateOperator.GROUP_BY)), Collections.singletonList(this.getFilter()));
        List<Term> joinTerms = this.getGroupBy().stream().map(groupByTerm -> TermV1.of(MatchType.TranslationOperator.EQUAL, (ColumnInfo)BasicColumnInfo.BasicColumnInfoBuilder.create(groupByTerm.alias()).build(), groupByTerm.columnInfo())).collect(Collectors.toList());
        return new LatitudeJoinSetDescription(filteredAggregateSet, this.setToFilter, ExplicitColumnList.of(Collections.emptyList()), AllColumnsColumnList.of(), JoinType.INNER, Optional.of("left"), Optional.of(""), MatchTypeV1.of(MatchType.TranslationMatchType.ALL, joinTerms));
    }
}

