/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import com.palantir.logsafe.Unsafe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.aggregates.LatitudeAggregate;
import latitude.api.aggregates.LatitudeAggregateOperator;
import latitude.api.aggregates.LatitudeGroupBy;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

@Unsafe
public final class LatitudeAggregateSetDescription
implements LatitudeSetDescription {
    private final LatitudeSetDescription baseSet;
    private final List<LatitudeGroupBy> groupBy;
    private final List<LatitudeAggregate> aggregates;
    @Unsafe
    private final Optional<String> orderByColumn;
    private final LatitudeAggregateOperator operator;

    @JsonCreator
    public LatitudeAggregateSetDescription(@JsonProperty(value="baseSet") LatitudeSetDescription baseSet, @JsonProperty(value="groupBy") List<LatitudeGroupBy> groupBy, @JsonProperty(value="aggregates") List<LatitudeAggregate> aggregates, @JsonProperty(value="orderByColumn") Optional<String> orderByColumn, @JsonProperty(value="operator") Optional<LatitudeAggregateOperator> operator) {
        this.baseSet = baseSet;
        this.groupBy = groupBy;
        this.aggregates = aggregates;
        this.orderByColumn = orderByColumn.flatMap(column -> column.isEmpty() ? Optional.empty() : Optional.of(column));
        this.operator = operator.orElse(LatitudeAggregateOperator.GROUP_BY);
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public LatitudeSetDescription getBaseSet() {
        return this.baseSet;
    }

    public List<LatitudeGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public List<LatitudeAggregate> getAggregates() {
        return this.aggregates;
    }

    @Unsafe
    public Optional<String> getOrderByColumn() {
        return this.orderByColumn;
    }

    public LatitudeAggregateOperator getOperator() {
        return this.operator;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudeAggregateSetDescription that = (LatitudeAggregateSetDescription)obj;
        return Objects.equals(this.baseSet, that.baseSet) && Objects.equals(this.groupBy, that.groupBy) && Objects.equals(this.aggregates, that.aggregates) && Objects.equals(this.orderByColumn, that.orderByColumn) && this.operator == that.operator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseSet, this.groupBy, this.aggregates, this.orderByColumn, this.operator});
    }

    @Unsafe
    public String toString() {
        return "LatitudeAggregateSetDescription{baseSet=" + this.baseSet + ", groupBy=" + this.groupBy + ", aggregates=" + this.aggregates + ", orderByColumn=" + this.orderByColumn + ", operator=" + this.operator + "}";
    }
}

