/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import com.palantir.logsafe.Unsafe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.graph.boards.combinecolumns.CombinedColumnPosition;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

@Unsafe
public final class LatitudeCombineColumnSetDescription
implements LatitudeSetDescription {
    private static final boolean REMOVE_COMBINED_COLUMNS_DEFAULT_VALUE = true;
    private final LatitudeSetDescription parent;
    @Unsafe
    private final String delimiter;
    @Unsafe
    private final List<String> inputColumns;
    private final Optional<Boolean> removeCombinedColumns;
    private final CombinedColumnPosition combinedColumnPosition;

    @JsonCreator
    public LatitudeCombineColumnSetDescription(@JsonProperty(value="parent") LatitudeSetDescription parent, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="columns") @JsonAlias(value={"inputColumns"}) List<String> inputColumns, @JsonProperty(value="removeCombinedColumns") Optional<Boolean> removeCombinedColumns, @JsonProperty(value="combinedColumnPosition") Optional<CombinedColumnPosition> combinedColumnPosition) {
        this.parent = parent;
        this.delimiter = delimiter;
        this.inputColumns = inputColumns;
        this.removeCombinedColumns = removeCombinedColumns.isPresent() && removeCombinedColumns.get() != false ? Optional.empty() : removeCombinedColumns;
        this.combinedColumnPosition = combinedColumnPosition.orElse(CombinedColumnPosition.DEFAULT_VALUE);
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public LatitudeSetDescription getParent() {
        return this.parent;
    }

    @Unsafe
    public String getDelimiter() {
        return this.delimiter;
    }

    @Unsafe
    public List<String> getInputColumns() {
        return this.inputColumns;
    }

    public boolean shouldRemoveCombinedColumns() {
        return this.getRemoveCombinedColumns().orElse(true);
    }

    public Optional<Boolean> getRemoveCombinedColumns() {
        return this.removeCombinedColumns;
    }

    public CombinedColumnPosition getCombinedColumnPosition() {
        return this.combinedColumnPosition;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudeCombineColumnSetDescription that = (LatitudeCombineColumnSetDescription)obj;
        return Objects.equals(this.removeCombinedColumns, that.removeCombinedColumns) && Objects.equals(this.parent, that.parent) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.inputColumns, that.inputColumns) && this.combinedColumnPosition == that.combinedColumnPosition;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parent, this.delimiter, this.inputColumns, this.removeCombinedColumns, this.combinedColumnPosition});
    }

    @Unsafe
    public String toString() {
        return "LatitudeCombineColumnSetDescription{parent=" + this.parent + ", delimiter='" + this.delimiter + "', inputColumns=" + this.inputColumns + ", removeCombinedColumns=" + this.removeCombinedColumns + ", combinedColumnPosition=" + this.combinedColumnPosition + "}";
    }
}

