/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.util.Objects;
import java.util.Optional;
import latitude.api.description.LatitudeInitialSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.resources.ContourResourceIdentifiers;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class LatitudeInitialIdentifiedSetDescription
implements LatitudeInitialSetDescription {
    private final String identifier;
    @Nullable
    private final String transaction;
    @Nullable
    private final String schemaId;
    @Nullable
    private final String viewMetadataId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Optional<ResourceIdentifier> maybeStartTransaction;

    public LatitudeInitialIdentifiedSetDescription(String identifier, String transaction, String schemaId, String viewMetadataId) {
        this(identifier, transaction, schemaId, viewMetadataId, Optional.empty());
    }

    @JsonCreator
    public LatitudeInitialIdentifiedSetDescription(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="transaction") String transaction, @JsonProperty(value="schemaId") String schemaId, @JsonProperty(value="viewMetadataId") String viewMetadataId, @JsonProperty(value="maybeStartTransaction") Optional<ResourceIdentifier> maybeStartTransaction) {
        this.identifier = identifier;
        this.transaction = transaction;
        this.schemaId = schemaId;
        this.viewMetadataId = viewMetadataId;
        this.maybeStartTransaction = maybeStartTransaction;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @Nullable
    public String getSchemaId() {
        return this.schemaId;
    }

    @Nullable
    public String getViewMetadataId() {
        return this.viewMetadataId;
    }

    public Optional<ResourceIdentifier> getMaybeStartTransaction() {
        return this.maybeStartTransaction;
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.transaction, this.schemaId, this.viewMetadataId, this.maybeStartTransaction);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudeInitialIdentifiedSetDescription other = (LatitudeInitialIdentifiedSetDescription)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier()) && Objects.equals(this.getTransaction(), other.getTransaction()) && Objects.equals(this.getSchemaId(), other.getSchemaId()) && Objects.equals(this.getViewMetadataId(), other.getViewMetadataId()) && Objects.equals(this.getMaybeStartTransaction(), other.getMaybeStartTransaction());
    }

    @Override
    public ResourceIdentifier rid(String instance) {
        return ContourResourceIdentifiers.datasetRi(instance, this.identifier);
    }

    public String toString() {
        return "LatitudeInitialIdentifiedSetDescription{identifier='" + this.identifier + "', transaction='" + this.transaction + "', schemaId='" + this.schemaId + "', viewMetadataId='" + this.viewMetadataId + "', maybeStartTransaction='" + this.maybeStartTransaction + "'}";
    }
}

