/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.column.aliased.AliasedColumn;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.graph.boards.pivottable.PivotTableAggregateInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class LatitudePivotSetDescription
implements LatitudeSetDescription {
    private final LatitudeSetDescription parent;
    private final List<AliasedColumn> rowAggregates;
    private final List<AliasedColumn> columnAggregates;
    private final List<PivotTableAggregateInfo> aggregates;
    private final boolean usePivotBoardFormat;

    public LatitudePivotSetDescription(@JsonProperty(value="parent") LatitudeSetDescription parent, @JsonProperty(value="rowAggregates") List<AliasedColumn> rowAggregates, @JsonProperty(value="columnAggregates") List<AliasedColumn> columnAggregates, @JsonProperty(value="aggregates") List<PivotTableAggregateInfo> aggregates, @JsonProperty(value="usePivotBoardFormat") Optional<Boolean> usePivotBoardFormat) {
        this.parent = parent;
        this.rowAggregates = rowAggregates;
        this.columnAggregates = columnAggregates;
        this.aggregates = aggregates;
        this.usePivotBoardFormat = usePivotBoardFormat.orElse(false);
    }

    public LatitudeSetDescription getParent() {
        return this.parent;
    }

    public List<AliasedColumn> getRowAggregates() {
        return this.rowAggregates;
    }

    public List<AliasedColumn> getColumnAggregates() {
        return this.columnAggregates;
    }

    public List<PivotTableAggregateInfo> getAggregates() {
        return this.aggregates;
    }

    public boolean getUsePivotBoardFormat() {
        return this.usePivotBoardFormat;
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.getParent(), this.getRowAggregates(), this.getColumnAggregates(), this.getAggregates(), this.getUsePivotBoardFormat());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudePivotSetDescription that = (LatitudePivotSetDescription)obj;
        return Objects.equals(this.parent, that.getParent()) && Objects.equals(this.rowAggregates, that.getRowAggregates()) && Objects.equals(this.columnAggregates, that.getColumnAggregates()) && Objects.equals(this.aggregates, that.getAggregates()) && this.usePivotBoardFormat == that.getUsePivotBoardFormat();
    }
}

