/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import com.palantir.logsafe.UnsafeArg;
import java.util.Map;
import java.util.Set;
import latitude.api.description.ImmutableLatitudeSqlSetDescription;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.apache.commons.lang3.text.StrLookup;
import shadow.palantir.driver.org.apache.commons.lang3.text.StrSubstitutor;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeName(value="sql")
@JsonDeserialize(as=ImmutableLatitudeSqlSetDescription.class)
@JsonSerialize(as=ImmutableLatitudeSqlSetDescription.class)
@Value.Immutable
public interface LatitudeSqlSetDescription
extends LatitudeSetDescription {
    public static final String SQL_PARAM_PREFIX = "${";
    public static final String SQL_PARAM_SUFFIX = "}";

    public Map<String, LatitudeSetDescription> parentsByParam();

    public String sqlQuery();

    @Override
    default public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    default public void check() {
        this.checkAllParametersAreDefined();
    }

    default public void checkAllParametersAreDefined() {
        StrSubstitutor substitutor = new StrSubstitutor(new ParameterValidationResolver(this.parentsByParam().keySet()), SQL_PARAM_PREFIX, SQL_PARAM_SUFFIX, '$');
        substitutor.replace(this.sqlQuery());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableLatitudeSqlSetDescription.Builder {
    }

    public static final class ParameterValidationResolver
    extends StrLookup<String> {
        private final Set<String> params;

        ParameterValidationResolver(Set<String> params) {
            this.params = params;
        }

        @Override
        public String lookup(String key) {
            ContourExceptions.client400PreconditionWithSafeMessage(this.params.contains(key), "SQL query contains undefined parameter", UnsafeArg.of("parameter", key));
            return null;
        }
    }
}

