/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.time.OffsetDateTime;
import java.util.Optional;
import latitude.api.description.ImmutableLatitudeTableSetDescription;
import latitude.api.description.LatitudeInitialSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import latitude.api.path.TableRid;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonFormat;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableLatitudeTableSetDescription.class)
@JsonSerialize(as=ImmutableLatitudeTableSetDescription.class)
@JsonTypeName(value="table")
@Value.Immutable
public interface LatitudeTableSetDescription
extends LatitudeInitialSetDescription {
    public TableRid tableRid();

    public String branch();

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ")
    public OffsetDateTime asof();

    @Value.Default
    default public boolean allowQueryingLaterThanAsOf() {
        return true;
    }

    @Value.Lazy
    default public Optional<OffsetDateTime> asofToQuery() {
        return this.allowQueryingLaterThanAsOf() ? Optional.empty() : Optional.of(this.asof());
    }

    @Override
    default public ResourceIdentifier rid(String instance) {
        return this.tableRid().getRid();
    }

    @Override
    default public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableLatitudeTableSetDescription.Builder {
    }
}

