/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.column.ColumnInfo;
import latitude.api.description.AddedColumnsPosition;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.description.LatitudeSetDescriptionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class LatitudeWithAddedColumnsSetDescription
implements LatitudeSetDescription {
    private final LatitudeSetDescription origin;
    private final List<ColumnInfo> addedColumns;
    private final AddedColumnsPosition addedColumnsPosition;

    public LatitudeWithAddedColumnsSetDescription(@JsonProperty(value="origin") LatitudeSetDescription origin, @JsonProperty(value="addedColumns") List<ColumnInfo> addedColumns, @JsonProperty(value="addedColumnsPosition") Optional<AddedColumnsPosition> addedColumnsPosition) {
        this.origin = origin;
        this.addedColumns = addedColumns;
        this.addedColumnsPosition = addedColumnsPosition.orElse(AddedColumnsPosition.FRONT);
    }

    public LatitudeSetDescription getOrigin() {
        return this.origin;
    }

    public List<ColumnInfo> getAddedColumns() {
        return this.addedColumns;
    }

    public AddedColumnsPosition getAddedColumnsPosition() {
        return this.addedColumnsPosition;
    }

    @Override
    public <T, V extends LatitudeSetDescriptionVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.origin, this.addedColumns, this.addedColumnsPosition});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatitudeWithAddedColumnsSetDescription other = (LatitudeWithAddedColumnsSetDescription)obj;
        return Objects.equals(this.getOrigin(), other.getOrigin()) && Objects.equals(this.getAddedColumns(), other.getAddedColumns()) && Objects.equals((Object)this.getAddedColumnsPosition(), (Object)other.getAddedColumnsPosition());
    }

    public String toString() {
        return "LatitudeWithAddedColumnsSetDescription{origin=" + this.origin + ", addedColumns=" + this.addedColumns + ", addedColumnsPosition=" + this.addedColumnsPosition + "}";
    }
}

