/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description.replacedcolumns;

import java.util.Objects;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.renamed.RenamedColumnInfoV1;
import latitude.api.description.replacedcolumns.ReplacedColumnDescription;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class RenamedReplacedColumnDescription
implements ReplacedColumnDescription {
    private final String columnName;
    private final String newColumnName;

    public RenamedReplacedColumnDescription(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName) {
        this.columnName = columnName;
        this.newColumnName = newColumnName;
    }

    @Override
    public IdentifiableColumn makeColumnInfo(IdentifiableColumn column) {
        return new RenamedColumnInfoV1(column, this.newColumnName);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenamedReplacedColumnDescription that = (RenamedReplacedColumnDescription)obj;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.newColumnName, that.newColumnName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.newColumnName);
    }

    public String toString() {
        return "RenamedReplacedColumnDescription{columnName='" + this.columnName + "', newColumnName='" + this.newColumnName + "'}";
    }
}

