/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.description.replacedcolumns;

import java.util.Objects;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.retyped.ColumnDataType;
import latitude.api.column.retyped.RetypedColumnInfoV1;
import latitude.api.description.replacedcolumns.ReplacedColumnDescription;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class RetypedColumnDescription
implements ReplacedColumnDescription {
    private final String columnName;
    private final ColumnDataType newColumnType;

    @JsonCreator
    public RetypedColumnDescription(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnType") ColumnDataType newColumnType) {
        this.columnName = columnName;
        this.newColumnType = newColumnType;
    }

    @Override
    public IdentifiableColumn makeColumnInfo(IdentifiableColumn column) {
        return new RetypedColumnInfoV1(column, this.newColumnType);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public ColumnDataType getNewColumnType() {
        return this.newColumnType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RetypedColumnDescription that = (RetypedColumnDescription)obj;
        return Objects.equals(this.columnName, that.columnName) && this.newColumnType == that.newColumnType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.newColumnType});
    }

    public String toString() {
        return "RetypedColumnDescription{columnName='" + this.columnName + "', newColumnType=" + this.newColumnType + "}";
    }
}

