/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.exception;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import shadow.palantir.driver.com.google.common.base.Throwables;

public abstract class AbstractExceptionManager {
    public static final String USER_ERROR_MESSAGE = "contourUserErrorMessage";
    public static final String SAFE_INTERNAL_ERROR_MESSAGE = "contourInternalErrorMessage";
    public static final String STACKTRACE = "stacktrace";

    @Unsafe
    public static Arg<String> stackTraceString(Throwable throwable) {
        return UnsafeArg.of(STACKTRACE, Throwables.getStackTraceAsString(throwable));
    }

    @Unsafe
    public static Arg<String> unsafeUserMessage(String message) {
        return UnsafeArg.of(USER_ERROR_MESSAGE, message);
    }

    public static Arg<String> safeInternalMessage(String message) {
        return SafeArg.of(SAFE_INTERNAL_ERROR_MESSAGE, message);
    }

    public static Arg<String> safeUserMessage(String message) {
        return SafeArg.of(USER_ERROR_MESSAGE, message);
    }
}

