/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.exception;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.Optional;
import latitude.api.exception.AbstractExceptionManager;
import latitude.api.exception.ErrorName;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ErrorType;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ServiceException;
import shadow.palantir.driver.org.apache.commons.lang3.ArrayUtils;

public final class ContourExceptions
extends AbstractExceptionManager {
    public static final ErrorType CLIENT_400_ILLEGAL_ARGUMENT = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, ErrorName.CLIENT_400_ILLEGAL_ARGUMENT.toString());
    private static final ErrorType SERVER_500_ILLEGAL_STATE = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.SERVER_500_ILLEGAL_STATE.toString());
    private static final ErrorType SERVER_500_ILLEGAL_ENUM = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.SERVER_500_ILLEGAL_ENUM.toString());
    private static final ErrorType SERVER_500_UNSUPPORTED = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.SERVER_500_UNSUPPORTED.toString());
    public static final ErrorType SERVER_500_UNHANDLED = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.SERVER_500_UNHANDLED.toString());

    public static Arg exceptionTypeArg(Throwable cause) {
        return SafeArg.of("exceptionType", cause.getClass().getSimpleName());
    }

    @Unsafe
    public static Arg exceptionMessageArg(Throwable cause) {
        return UnsafeArg.of("exceptionMessage", Optional.ofNullable(cause.getMessage()).orElse(""));
    }

    private ContourExceptions() {
    }

    public static ServiceException client400(String unsafeUserMessage, String safeInternalMessage) {
        return new ServiceException(CLIENT_400_ILLEGAL_ARGUMENT, ContourExceptions.unsafeUserMessage(unsafeUserMessage), ContourExceptions.safeInternalMessage(safeInternalMessage));
    }

    public static ServiceException client400(String unsafeUserMessage, String safeInternalMessage, Arg ... loggableArgs) {
        return new ServiceException(CLIENT_400_ILLEGAL_ARGUMENT, ArrayUtils.addAll(loggableArgs, ContourExceptions.unsafeUserMessage(unsafeUserMessage), ContourExceptions.safeInternalMessage(safeInternalMessage)));
    }

    public static ServiceException client400WithSafeMessage(String safeUserMessage, Arg ... loggableArgs) {
        return ContourExceptions.client400(safeUserMessage, safeUserMessage, loggableArgs);
    }

    public static void client400CheckNotNullWithSafeMessage(Object objectToCheck, String safeUserMessage, Arg ... loggableArgs) {
        ContourExceptions.client400Precondition(objectToCheck != null, safeUserMessage, safeUserMessage, loggableArgs);
    }

    public static void client400PreconditionWithSafeMessage(boolean precondition, String safeUserMessage, Arg ... loggableArgs) {
        ContourExceptions.client400Precondition(precondition, safeUserMessage, safeUserMessage, loggableArgs);
    }

    public static void client400Precondition(boolean precondition, String unsafeUserMessage, String safeInternalMessage, Arg ... loggableArgs) {
        if (precondition) {
            return;
        }
        throw new ServiceException(CLIENT_400_ILLEGAL_ARGUMENT, ArrayUtils.addAll(loggableArgs, ContourExceptions.unsafeUserMessage(unsafeUserMessage), ContourExceptions.safeInternalMessage(safeInternalMessage)));
    }

    public static ServiceException server500(String safeInternalMessage, Arg ... loggableArgs) {
        return new ServiceException(SERVER_500_ILLEGAL_STATE, ArrayUtils.addAll(loggableArgs, ContourExceptions.safeInternalMessage(safeInternalMessage)));
    }

    public static ServiceException server500(String safeInternalMessage, Exception cause, Arg ... loggableArgs) {
        return new ServiceException(SERVER_500_ILLEGAL_STATE, (Throwable)cause, ArrayUtils.addAll(loggableArgs, ContourExceptions.safeInternalMessage(safeInternalMessage), ContourExceptions.exceptionTypeArg(cause), ContourExceptions.exceptionMessageArg(cause)));
    }

    public static ServiceException server500(String safeInternalMessage, Exception cause) {
        return new ServiceException(SERVER_500_ILLEGAL_STATE, (Throwable)cause, ContourExceptions.safeInternalMessage(safeInternalMessage), ContourExceptions.exceptionTypeArg(cause), ContourExceptions.exceptionMessageArg(cause));
    }

    public static ServiceException server500(String unsafeUserMessage, String safeInternalMessage, Arg ... loggableArgs) {
        return new ServiceException(SERVER_500_ILLEGAL_STATE, ArrayUtils.addAll(loggableArgs, ContourExceptions.unsafeUserMessage(unsafeUserMessage), ContourExceptions.safeInternalMessage(safeInternalMessage)));
    }

    public static ServiceException serverUnknownUnionType(String safeUnknownTypeName, Class<?> parentType) {
        return ContourExceptions.server500("Unknown subtype", SafeArg.of("unknown-type", safeUnknownTypeName), SafeArg.of("parent-type", parentType));
    }

    public static ServiceException clientUnknownUnionType(String safeUnknownTypeName, Class<?> parentType) {
        return ContourExceptions.client400("Unknown subtype", "Unknown subtype", SafeArg.of("unknown-type", safeUnknownTypeName), SafeArg.of("parent-type", parentType));
    }

    public static <T> T server500CheckNotNull(T objectToCheck, String safeInternalMessage, Arg ... loggableArgs) {
        ContourExceptions.server500Precondition(objectToCheck != null, safeInternalMessage, loggableArgs);
        return objectToCheck;
    }

    public static ServiceException server500IllegalEnum(Enum enumObject) {
        return new ServiceException(SERVER_500_ILLEGAL_ENUM, SafeArg.of("enumType", enumObject.getDeclaringClass().getSimpleName()), SafeArg.of("enumValue", enumObject.toString()));
    }

    public static void server500Precondition(boolean precondition, String safeInternalMessage, Arg ... loggableArgs) {
        if (precondition) {
            return;
        }
        throw new ServiceException(SERVER_500_ILLEGAL_STATE, ArrayUtils.addAll(loggableArgs, ContourExceptions.safeInternalMessage(safeInternalMessage)));
    }

    public static ServiceException server500Unsupported(String safeInternalMessage) {
        return new ServiceException(SERVER_500_UNSUPPORTED, ContourExceptions.safeInternalMessage(safeInternalMessage));
    }
}

