/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.exception;

import com.palantir.logsafe.SafeArg;
import java.util.Map;
import java.util.function.Function;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.one.util.streamex.StreamEx;

public enum ErrorName {
    COMPASS_RESOURCE_LIMITS_REACHED("Contour:CompassResourceLimitsReached"),
    CLIENT_400_ILLEGAL_ARGUMENT("Contour:ClientIllegalArgument"),
    DATASET_VIEW_NOT_FOUND("Contour:DatasetViewNotFound"),
    FORCE_CANCELED("Contour:ForceCanceled"),
    INSUFFICIENT_PERMISSION("Contour:InsufficientPermission"),
    JOB_CANCELED("Contour:JobCanceled"),
    JOB_FAILED("Contour:JobFailed"),
    JOB_NOT_FOUND("Contour:JobNotFound"),
    JOB_TIMED_OUT("Contour:JobTimedOut"),
    NO_RECENT_REFERENCES("Contour:NoRecentReferences"),
    JOB_FAILED_TO_START("Contour:JobFailedToStart"),
    PARAMETER_VALUE_NOT_FOUND("Contour:ParameterValueNotFound"),
    PERMISSION_UPGRADE_REQUIRED("Contour:PermissionUpgradeRequired"),
    QOS_UNAVAILABLE("Contour:QosUnavailable"),
    READ_FAILED("Contour:ReadFailed"),
    READ_JSON_VALUE_FAILED("Contour:ReadJsonValueFailed"),
    SCHEMA_NOT_FOUND("Contour:SchemaNotFound"),
    SERVER_500_ILLEGAL_ENUM("Contour:ServerIllegalEnum"),
    SERVER_500_ILLEGAL_STATE("Contour:ServerIllegalState"),
    SERVER_500_UNHANDLED("Contour:ServerUnhandledException"),
    SERVER_500_UNSUPPORTED("Contour:ServerUnsupported"),
    USER_RESOURCE_LIMITS_REACHED("Contour:UserResourceLimitsReached"),
    WRITE_FAILED("Contour:WriteFailed"),
    BACKEND_NO_LONGER_AVAILABLE("Contour:BackendNoLongerAvailable");

    private static final Map<String, ErrorName> errorNamesByExternalName;
    private final String errorName;

    private ErrorName(String errorName) {
        this.errorName = errorName;
    }

    @JsonCreator
    public static ErrorName fromJsonValue(@JsonProperty String errorName) {
        ContourExceptions.server500Precondition(errorNamesByExternalName.containsKey(errorName), "Invalid value for ErrorName", SafeArg.of("errorName", errorName));
        return errorNamesByExternalName.get(errorName);
    }

    @JsonValue
    public String toString() {
        return this.errorName;
    }

    static {
        errorNamesByExternalName = StreamEx.of(ErrorName.values()).toMap(ErrorName::toString, Function.identity());
    }
}

