/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableBinaryExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.collect.Iterables;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableBinaryExpression.class)
@JsonSerialize(as=ImmutableBinaryExpression.class)
@Value.Immutable
public abstract class BinaryExpression
extends Expression {
    private static final String CONCATENATE_CONSTANT = "||";
    private static final String MULTIPLY_CONSTANT = "*";
    private static final String DIVIDE_CONSTANT = "/";
    private static final String MODULUS_CONSTANT = "%";
    private static final String ADD_CONSTANT = "+";
    private static final String SUBTRACT_CONSTANT = "-";
    private static final String LESS_THAN_CONSTANT = "<";
    private static final String LESS_THAN_OR_EQUAL_CONSTANT = "<=";
    private static final String GREATER_THAN_CONSTANT = ">";
    private static final String GREATER_THAN_OR_EQUAL_CONSTANT = ">=";
    private static final String EQUAL_1_CONSTANT = "=";
    private static final String EQUAL_2_CONSTANT = "==";
    private static final String NOT_EQUAL_1_CONSTANT = "!=";
    private static final String NOT_EQUAL_2_CONSTANT = "<>";
    private static final String IS_CONSTANT = "IS";
    private static final String IS_NOT_CONSTANT = "IS NOT";
    private static final String LIKE_CONSTANT = "LIKE";
    private static final String RLIKE_CONSTANT = "RLIKE";
    private static final String AND_CONSTANT = "AND";
    private static final String OR_CONSTANT = "OR";

    @Value.Parameter
    public abstract Expression left();

    @Value.Parameter
    public abstract BinaryOperation operation();

    @Value.Parameter
    public abstract Expression right();

    @Override
    public final List<String> getSourceTables() {
        return ImmutableList.copyOf(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.left().getSourceTables())).addAll(this.right().getSourceTables())).build());
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return this.operation().returnType.getAttributes();
    }

    @Override
    public final boolean isAggregating() {
        return this.left().isAggregating() || this.right().isAggregating();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        return "(" + this.left().accept(expressionResolver) + " " + this.operation().getExpressionRepresentation() + " " + this.right().accept(expressionResolver) + ")";
    }

    @Override
    public String userFriendlyName() {
        return "binary expression";
    }

    public static BinaryExpression of(Expression left, BinaryOperation operation, Expression right) {
        return ImmutableBinaryExpression.of(left, operation, right);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableBinaryExpression.Builder {
    }

    public static enum BinaryOperation {
        CONCATENATE(Expression.ReturnType.STRING, "||"),
        MULTIPLY(Expression.ReturnType.NUMBER, "*"),
        DIVIDE(Expression.ReturnType.NUMBER, "/"),
        MODULUS(Expression.ReturnType.NUMBER, "%"),
        ADD(Expression.ReturnType.NUMBER, "+"),
        SUBTRACT(Expression.ReturnType.NUMBER, "-"),
        LESS_THAN(Expression.ReturnType.BOOLEAN, "<"),
        LESS_THAN_OR_EQUAL(Expression.ReturnType.BOOLEAN, "<="),
        GREATER_THAN(Expression.ReturnType.BOOLEAN, ">"),
        GREATER_THAN_OR_EQUAL(Expression.ReturnType.BOOLEAN, ">="),
        EQUAL(Expression.ReturnType.BOOLEAN, "=", "=="),
        NOT_EQUAL(Expression.ReturnType.BOOLEAN, "!=", "<>"),
        IS(Expression.ReturnType.BOOLEAN, "IS"),
        IS_NOT(Expression.ReturnType.BOOLEAN, "IS NOT"),
        LIKE(Expression.ReturnType.BOOLEAN, "LIKE"),
        RLIKE(Expression.ReturnType.BOOLEAN, "RLIKE"),
        AND(Expression.ReturnType.BOOLEAN, "AND"),
        OR(Expression.ReturnType.BOOLEAN, "OR");

        private final Expression.ReturnType returnType;
        private final ImmutableSet<String> expressionRepresentation;

        private BinaryOperation(Expression.ReturnType returnType, String ... expressionRepresentation) {
            this.returnType = returnType;
            this.expressionRepresentation = ImmutableSet.copyOf(expressionRepresentation);
        }

        public Expression.ReturnType getReturnType() {
            return this.returnType;
        }

        public static BinaryOperation parse(String operation) {
            String op;
            switch (op = operation.toUpperCase(Locale.ROOT)) {
                case "||": {
                    return CONCATENATE;
                }
                case "*": {
                    return MULTIPLY;
                }
                case "/": {
                    return DIVIDE;
                }
                case "%": {
                    return MODULUS;
                }
                case "+": {
                    return ADD;
                }
                case "-": {
                    return SUBTRACT;
                }
                case "<": {
                    return LESS_THAN;
                }
                case "<=": {
                    return LESS_THAN_OR_EQUAL;
                }
                case ">": {
                    return GREATER_THAN;
                }
                case ">=": {
                    return GREATER_THAN_OR_EQUAL;
                }
                case "=": {
                    return EQUAL;
                }
                case "==": {
                    return EQUAL;
                }
                case "!=": {
                    return NOT_EQUAL;
                }
                case "<>": {
                    return NOT_EQUAL;
                }
                case "IS": {
                    return IS;
                }
                case "LIKE": {
                    return LIKE;
                }
                case "RLIKE": {
                    return RLIKE;
                }
                case "AND": {
                    return AND;
                }
                case "OR": {
                    return OR;
                }
            }
            if (op.matches("IS[\\s]+NOT")) {
                return IS_NOT;
            }
            throw ContourExceptions.client400(String.format("Unrecognized binary operation '%s'.", operation), "Unrecognized binary operation.");
        }

        public String getExpressionRepresentation() {
            return Iterables.getFirst(this.expressionRepresentation, "");
        }
    }
}

