/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Expression;
import latitude.api.expression.Expressions;
import latitude.api.expression.ImmutableCaseExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableCaseExpression.class)
@JsonSerialize(as=ImmutableCaseExpression.class)
@Value.Immutable
public abstract class CaseExpression
extends Expression {
    public static CaseExpression of(Optional<Expression> base, List<Expression> whens, List<Expression> thens, Optional<Expression> elze) {
        return ImmutableCaseExpression.of(base, whens, thens, elze);
    }

    @Override
    public final List<String> getSourceTables() {
        ImmutableSet.Builder sourceTables = ImmutableSet.builder();
        if (this.base().isPresent()) {
            sourceTables.addAll(this.base().get().getSourceTables());
        }
        for (Expression expr : this.whens()) {
            sourceTables.addAll(expr.getSourceTables());
        }
        for (Expression expr : this.thens()) {
            sourceTables.addAll(expr.getSourceTables());
        }
        if (this.elze().isPresent()) {
            sourceTables.addAll(this.elze().get().getSourceTables());
        }
        return ImmutableList.copyOf(sourceTables.build());
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        ImmutableList.Builder outputExpressions = ImmutableList.builder();
        outputExpressions.addAll(this.thens());
        outputExpressions.addAll((Iterable)this.elze().map(Collections::singleton).orElseGet(Collections::emptySet));
        return Expressions.getIntersectionOfAttributes((List<Expression>)((Object)outputExpressions.build()));
    }

    @Override
    public final boolean isAggregating() {
        for (Expression exp : this.thens()) {
            if (!exp.isAggregating()) continue;
            return true;
        }
        return this.elze().isPresent() && this.elze().get().isAggregating();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    public final void check() {
        ContourExceptions.client400PreconditionWithSafeMessage(!this.whens().isEmpty() && this.whens().size() == this.thens().size(), "Case statements must have at least one when/then, and must have equal number when/thens.", new Arg[0]);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        StringBuilder caseExpressionStringBuilder = new StringBuilder("(CASE");
        this.base().ifPresent(base -> caseExpressionStringBuilder.append(" ").append((String)base.accept(expressionResolver)));
        for (int i = 0; i < this.whens().size(); ++i) {
            caseExpressionStringBuilder.append("\nWHEN ");
            caseExpressionStringBuilder.append(this.whens().get(i).accept(expressionResolver));
            caseExpressionStringBuilder.append(" THEN ");
            caseExpressionStringBuilder.append(this.thens().get(i).accept(expressionResolver));
        }
        this.elze().ifPresent(elze -> {
            caseExpressionStringBuilder.append("\nELSE ");
            caseExpressionStringBuilder.append((String)elze.accept(expressionResolver));
        });
        caseExpressionStringBuilder.append("\nEND)");
        return caseExpressionStringBuilder.toString();
    }

    @Override
    public String userFriendlyName() {
        return "CASE expression";
    }

    @Value.Parameter
    public abstract Optional<Expression> base();

    @Value.Parameter
    public abstract List<Expression> whens();

    @Value.Parameter
    public abstract List<Expression> thens();

    @Value.Parameter
    public abstract Optional<Expression> elze();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableCaseExpression.Builder {
    }
}

