/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableCastExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableCastExpression.class)
@JsonSerialize(as=ImmutableCastExpression.class)
@Value.Immutable
public abstract class CastExpression
extends Expression {
    @Value.Parameter
    public abstract Expression expression();

    @Value.Parameter
    public abstract CastType asType();

    @Override
    public final List<String> getSourceTables() {
        return this.expression().getSourceTables();
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return this.asType().returnType.getAttributes();
    }

    @Override
    public final boolean isAggregating() {
        return this.expression().isAggregating();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        return "CAST(" + this.expression().accept(expressionResolver) + " AS " + this.asType().name() + ")";
    }

    @Override
    public String userFriendlyName() {
        return "CAST expression";
    }

    public static CastExpression of(Expression expression, CastType type) {
        return ImmutableCastExpression.of(expression, type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableCastExpression.Builder {
    }

    public static enum CastType {
        INTEGER(Expression.ReturnType.INTEGER),
        LONG(Expression.ReturnType.LONG),
        DOUBLE(Expression.ReturnType.DOUBLE),
        DECIMAL(Expression.ReturnType.DECIMAL),
        STRING(Expression.ReturnType.STRING),
        BOOLEAN(Expression.ReturnType.BOOLEAN),
        DATE(Expression.ReturnType.DATE),
        TIMESTAMP(Expression.ReturnType.TIMESTAMP);

        private final Expression.ReturnType returnType;

        private CastType(Expression.ReturnType returnType) {
            this.returnType = returnType;
        }

        public static CastType parse(String type) {
            return CastType.valueOf(type.toUpperCase(Locale.ROOT));
        }
    }
}

