/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableColumnExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableColumnExpression.class)
@JsonSerialize(as=ImmutableColumnExpression.class)
@Value.Immutable
public abstract class ColumnExpression
extends Expression {
    public static ColumnExpression of(ColumnInfo value) {
        return ImmutableColumnExpression.of(value);
    }

    @Override
    public final List<String> getSourceTables() {
        return this.value().getSourceTables();
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return this.value().getAttributes();
    }

    @Override
    public final boolean isAggregating() {
        return false;
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> _expressionResolver) {
        String columnName = this.value().getName();
        if (columnName == null) {
            columnName = "";
        }
        return "\"" + columnName.replace("\"", "\"\"") + "\"";
    }

    @Override
    public String userFriendlyName() {
        return "column expression";
    }

    @Value.Parameter
    public abstract ColumnInfo value();
}

