/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Unsafe;
import java.math.BigDecimal;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableDoubleLiteral;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.Literal;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableDoubleLiteral.class)
@JsonSerialize(as=ImmutableDoubleLiteral.class)
@Value.Immutable
public abstract class DoubleLiteral
extends Literal {
    public static DoubleLiteral of(Double value) {
        return ImmutableDoubleLiteral.of(value);
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return Expression.ReturnType.DOUBLE.getAttributes();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> _expressionResolver) {
        return BigDecimal.valueOf(this.value()).toPlainString();
    }

    @Override
    public String userFriendlyName() {
        return "double literal";
    }

    @Value.Parameter
    public abstract Double value();
}

