/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.ImmutableBinaryExpression;
import latitude.api.expression.ImmutableBooleanLiteral;
import latitude.api.expression.ImmutableCaseExpression;
import latitude.api.expression.ImmutableCastExpression;
import latitude.api.expression.ImmutableColumnExpression;
import latitude.api.expression.ImmutableDoubleLiteral;
import latitude.api.expression.ImmutableFunctionExpression;
import latitude.api.expression.ImmutableInExpression;
import latitude.api.expression.ImmutableIntegerLiteral;
import latitude.api.expression.ImmutableNullLiteral;
import latitude.api.expression.ImmutableParameterLiteral;
import latitude.api.expression.ImmutableStringLiteral;
import latitude.api.expression.ImmutableUnaryExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXTERNAL_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableBinaryExpression.class, name="BINARY_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableCaseExpression.class, name="CASE_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableBooleanLiteral.class, name="BOOLEAN_LITERAL"), @JsonSubTypes.Type(value=ImmutableCastExpression.class, name="CAST_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableFunctionExpression.class, name="FUNCTION_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableIntegerLiteral.class, name="INTEGER_LITERAL"), @JsonSubTypes.Type(value=ImmutableDoubleLiteral.class, name="DOUBLE_LITERAL"), @JsonSubTypes.Type(value=ImmutableParameterLiteral.class, name="PARAMETER_LITERAL"), @JsonSubTypes.Type(value=ImmutableStringLiteral.class, name="STRING_LITERAL"), @JsonSubTypes.Type(value=ImmutableUnaryExpression.class, name="UNARY_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableColumnExpression.class, name="COLUMN_EXPRESSION"), @JsonSubTypes.Type(value=ImmutableNullLiteral.class, name="NULL_LITERAL"), @JsonSubTypes.Type(value=ImmutableInExpression.class, name="IN_EXPRESSION")})
public abstract class Expression {
    @JsonIgnore
    public abstract List<String> getSourceTables();

    @JsonIgnore
    public abstract Set<ColumnAttribute> getAttributes();

    @JsonIgnore
    public abstract boolean isAggregating();

    @JsonIgnore
    public abstract <T> T accept(LatitudeExpressionVisitor<T> var1);

    @JsonIgnore
    @Value.Derived
    public abstract String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> var1);

    @JsonIgnore
    @Value.Derived
    public abstract String userFriendlyName();

    public static enum ReturnType {
        SAME_AS_INPUT(ImmutableSet.of()),
        STRING(ColumnAttribute.getStringAttributes()),
        NULL(ImmutableSet.of()),
        NUMBER(ColumnAttribute.getNumberAttributes()),
        LONG(ColumnAttribute.getNumberAttributes()),
        DOUBLE(ColumnAttribute.getNumberAttributes()),
        INTEGER(ColumnAttribute.getNumberAttributes()),
        DECIMAL(ColumnAttribute.getNumberAttributes()),
        TIMESTAMP(ColumnAttribute.getDateTimeAttributes()),
        DATE(ColumnAttribute.getLocalDateAttributes()),
        BOOLEAN(ColumnAttribute.getBooleanAttributes()),
        ARRAY(ImmutableSet.of()),
        INNER_TYPE_FROM_INPUT(ImmutableSet.of());

        private final ImmutableSet<ColumnAttribute> attributes;

        private ReturnType(Set<ColumnAttribute> attributes) {
            this.attributes = ImmutableSet.copyOf(attributes);
        }

        public Set<ColumnAttribute> getAttributes() {
            return this.attributes;
        }
    }
}

