/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.ColumnAttribute;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Expression;
import latitude.api.expression.NullLiteral;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;

public final class Expressions {
    private Expressions() {
    }

    public static Set<ColumnAttribute> getIntersectionOfAttributes(List<Expression> expressions) {
        if (expressions.isEmpty()) {
            return ImmutableSet.of();
        }
        List nonNullExpressions = expressions.stream().filter(expression -> !(expression instanceof NullLiteral)).collect(Collectors.toList());
        if (nonNullExpressions.isEmpty()) {
            throw ContourExceptions.client400WithSafeMessage("There must be at least one expression that is not NULL", new Arg[0]);
        }
        HashSet<ColumnAttribute> attributes = new HashSet<ColumnAttribute>(((Expression)nonNullExpressions.get(0)).getAttributes());
        for (Expression expr : nonNullExpressions.subList(1, nonNullExpressions.size())) {
            attributes.retainAll(expr.getAttributes());
        }
        return ImmutableSet.copyOf(attributes);
    }
}

