/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.Locale;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.ImmutableFrame;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableFrame.class)
@JsonSerialize(as=ImmutableFrame.class)
@Value.Immutable
public abstract class Frame {
    @Value.Parameter
    public abstract Optional<Parameter<Long>> range();

    @Value.Parameter
    public abstract FrameType type();

    @Value.Check
    public final void check() {
        if (this.type().equals((Object)FrameType.CURRENT_ROW)) {
            ContourExceptions.client400PreconditionWithSafeMessage(!this.range().isPresent(), "Window Function cannot use CURRENT_ROW and include a range.", new Arg[0]);
        }
    }

    public static Frame unbounded(FrameType type) {
        return ImmutableFrame.of(Optional.empty(), type);
    }

    public static Frame bounded(long range, FrameType type) {
        return Frame.bounded(ConcreteValue.of(range), type);
    }

    public static Frame bounded(@Nonnull Parameter<Long> range, FrameType type) {
        return ImmutableFrame.of(Optional.of(range), type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableFrame.Builder {
    }

    public static enum FrameType {
        PRECEDING,
        CURRENT_ROW,
        FOLLOWING;


        public static FrameType parse(String range) {
            String upperRange = range.toUpperCase(Locale.ROOT);
            if (upperRange.matches("CURRENT[\\s]+ROW")) {
                return CURRENT_ROW;
            }
            return FrameType.valueOf(upperRange);
        }
    }
}

