/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.Locale;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Frame;
import latitude.api.expression.ImmutableFrameBy;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableFrameBy.class)
@JsonSerialize(as=ImmutableFrameBy.class)
@Value.Immutable
public abstract class FrameBy {
    @Value.Parameter
    public abstract FrameByType type();

    @Value.Parameter
    public abstract Frame start();

    @Value.Parameter
    public abstract Frame end();

    @Value.Check
    public final void check() {
        if (this.start().type() == Frame.FrameType.FOLLOWING) {
            ContourExceptions.client400PreconditionWithSafeMessage(this.start().range().isPresent(), "Start frame cannot be unbounded following.", new Arg[0]);
        }
        if (this.end().type() == Frame.FrameType.PRECEDING) {
            ContourExceptions.client400PreconditionWithSafeMessage(this.end().range().isPresent(), "End frame cannot be unbounded preceding.", new Arg[0]);
        }
    }

    public static FrameBy of(FrameByType type, Frame start, Frame end) {
        return ImmutableFrameBy.of(type, start, end);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableFrameBy.Builder {
    }

    public static enum FrameByType {
        RANGE,
        ROWS;


        public static FrameByType parse(String type) {
            return FrameByType.valueOf(type.toUpperCase(Locale.ROOT));
        }
    }
}

